/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.concrete.ConcretePackage;
import org.eclipse.mddi.modelbus.description.concrete.Property;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class ProviderEndPoint
implements EndPoint {
    public static final String DEFAULT_REL_PATH = "modeling_services";
    private Map relativePath2AdapterMap = new HashMap();

    public AdapterStub getAdapterOfProviderTool(String relativePath) {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1, relativePath.length());
        }
        AdapterStub ad = (AdapterStub)this.relativePath2AdapterMap.get(relativePath);
        return ad;
    }

    public void manageAdapter(AdapterStub adapter) throws Exception {
        this.setUrlProperty(adapter);
        Tool toolDescription = adapter.getToolDescription();
        if (toolDescription == null) {
            RootLogger.getLogger().log(Level.WARNING, "Adapter: No tool description found.");
            return;
        }
        EndPointManagerImpl.getInstance().putEndPoint(DEFAULT_REL_PATH, this);
        this.relativePath2AdapterMap.put(ProviderEndPoint.getRelativePath(toolDescription), adapter);
    }

    private void setUrlProperty(AdapterStub adapter) throws Exception {
        Tool toolDescription = adapter.getToolDescription();
        Property pro = DescriptionUtil.getPropertyObject(toolDescription, "URL");
        if (pro == null) {
            pro = ConcretePackage.eINSTANCE.getConcreteFactory().createProperty();
            toolDescription.getProperty().add((Object)pro);
        }
        int port = ServerManager.getModelBusPort(adapter);
        AbstractServer s = ServerManager.getInstance().getServer(port);
        port = s.getPort();
        pro.setName("URL");
        pro.setValue("http://" + ServerManager.getHost() + ":" + port + "/" + s.getContext() + "/" + ProviderEndPoint.getRelativePath(toolDescription));
        RootLogger.getLogger().log(Level.INFO, "Assign URL to the Provider tool : " + pro.getValue());
    }

    public static String getRelativePath(Tool tool) {
        String path = "modeling_services/" + tool.getName();
        return path;
    }

    public static String getRelativePath(String toolName) {
        String path = "modeling_services/" + toolName;
        return path;
    }

    public Collection getAdapters() {
        return this.relativePath2AdapterMap.values();
    }

    public void removeAdapter(AdapterStub adapter) {
        this.relativePath2AdapterMap.values().remove(adapter);
    }

    public void execute(String relativePath, SOAPEnvelope req, SOAPEnvelope resp) {
        AdapterStub a = this.getAdapterOfProviderTool(relativePath);
        if (a != null) {
            RootLogger.getLogger().log(Level.INFO, String.valueOf(relativePath) + " -> " + a);
            a.getTransportManager().createWsInvocationReceiver().process(req, resp);
        } else {
            RootLogger.getLogger().log(Level.SEVERE, "No Tool bound to the URI " + relativePath);
            RootLogger.getLogger().log(Level.INFO, "Map has the following entries:");
            Iterator it = this.relativePath2AdapterMap.keySet().iterator();
            while (it.hasNext()) {
                RootLogger.getLogger().log(Level.INFO, it.next().toString());
            }
            try {
                DefaultWsInvocationReceiver.createSoapFault(resp, "No Tool bound to the URI " + relativePath);
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
    }
}

