/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async;

import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.soap.SOAPConnectionImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.PollObject;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.ResultNotReadyException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.SOAPAsyncConnection;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.ThreadPoolQueue;

public class SOAPAsyncConnectionImpl
extends SOAPAsyncConnection {
    private PollObject pollObject = new PollObject();
    private SOAPConnection syncConnection = new SOAPConnectionImpl();

    public String call(SOAPMessage request, Object endpoint, ThreadPoolQueue pool) throws SOAPException {
        String connectionId = String.valueOf(this.hashCode());
        this.launchThreadCall(request, endpoint, pool);
        return connectionId;
    }

    public boolean isResultReady() {
        return this.pollObject.isResultReady();
    }

    public Object getResult() throws ResultNotReadyException {
        return this.pollObject.getResult();
    }

    public void close() throws SOAPException {
        this.syncConnection.close();
    }

    private void launchThreadCall(SOAPMessage request, Object endpoint, ThreadPoolQueue pool) throws SOAPException {
        Task task = new Task(this.syncConnection, request, endpoint, this.pollObject);
        pool.execute(task);
    }

    private static class Task
    implements Runnable {
        private SOAPConnection connection;
        private SOAPMessage request;
        private Object endpoint;
        private PollObject po;

        public Task(SOAPConnection connection, SOAPMessage request, Object endpoint, PollObject po) {
            this.connection = connection;
            this.request = request;
            this.endpoint = endpoint;
            this.po = po;
        }

        public void run() {
            try {
                SOAPMessage resp = this.connection.call(this.request, this.endpoint);
                this.po.registerResult(resp);
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
    }
}

