/*
 * $RCSfile: IndentStream.java,v $
 * $Date: 2007/04/19 00:44:20 $
 * $Revision: 1.3 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * IndentStream.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.3 $ $Date: 2007/04/19 00:44:20 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;

/**
 * 
 * This class prints messages to the specified console (wrapped OutputStream)
 * and also to the specified logger
 * 
 * 
 * @author Prawee Sriplakich (LIP6)
 * 
 * 
 */
public class IndentStream {

    boolean enableLog = true;
    boolean enableConsole = true;
    
    int initialIndent = 0;

    String prefix = "";


    PrintStream consoleDestination = null;

    /**
     * 
     * @param prefix
     *            The prefix to add to console messages
     * @param logger
     *            The logger to output debug messages
     * @param console 
     *            The destination of the console message (may be null)
     */
    public IndentStream(String prefix, OutputStream console) {
        this.prefix = prefix;
        setConsoleDestination(console);
    }


    

    public void println(String message) {
        println(0, message);
    }

    public void println(int indentLevel, String message) {
        StringBuffer indentString = new StringBuffer("");
        if(enableLog ) {
            // initial indent does not improuve readability of log messsages
              for (int i = 0; i < indentLevel; i++) {
                indentString.append("   ");
              }
              org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, indentString + message);
        }
        if (enableConsole && consoleDestination != null) {
            for (int i = 0; i < initialIndent ; i++) {
                indentString.append("   ");
            }
            consoleDestination.println(indentString +prefix +message);
        }

    }

    /////////////////// Getters and Setters

    /**
     * @return Returns the consoleDestination.
     */
    public PrintStream getConsoleDestination() {
        return consoleDestination;
    }

    /**
     * @param consoleDestination
     *            The consoleDestination to set.
     */
    public void setConsoleDestination(OutputStream console) {
        if (console instanceof PrintStream) {
            this.consoleDestination = (PrintStream) console;
        } else if(console!=null) {
            this.consoleDestination = new PrintStream(console);
        }
    }

    /**
     * Set the indent to be added 
     * to all printed messages
     * 
     * @param indent
     *            The indent to set.
     */
    public void setInitialIndent(int indent) {
        this.initialIndent = indent;
    }

    /**
     * @return Returns the initialIntent.
     */
    public int getInitialIndent() {
        return initialIndent;
    }




    /**
     * @return Returns the enableConsole.
     */
    public boolean isEnableConsole() {
        return enableConsole;
    }




    /**
     * @param enableConsole The enableConsole to set.
     */
    public void setEnableConsole(boolean enableConsole) {
        this.enableConsole = enableConsole;
    }




    /**
     * @return Returns the enableLog.
     */
    public boolean isEnableLog() {
        return enableLog;
    }




    /**
     * @param enableLog The enableLog to set.
     */
    public void setEnableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }
}
