/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 13 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.QualifiedServiceName;
import org.eclipse.mddi.modelbus.description.abstract_.AbstractFactory;
import org.eclipse.mddi.modelbus.description.abstract_.DirectionKind;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl;
import org.eclipse.mddi.modelbus.description.concrete.ConcreteFactory;
import org.eclipse.mddi.modelbus.description.concrete.Property;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.description.concrete.impl.ConcretePackageImpl;

/**
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * 
 */
public class DescriptionUtil {

    public static final String IS_SESSION_ENABLED = "IsSessionEnabled";

    public static final AbstractFactory abstractFactory = AbstractPackageImpl.init().getAbstractFactory();
    
    public static final ConcreteFactory concreteFactory = ConcretePackageImpl.init().getConcreteFactory();
    
    /**
     * 
     * getServiceDescription
     * 
     * @param serviceName
     *            the service name which can be qualified or not qualified name =
     *            [tool] . [Interface] . [service] or [Interface] . [service]
     * 
     * Example: Objecteering.ModelEdition.loadModel or ModelEdition.loadModel
     * 
     * @return
     * 
     * 
     */
    public static ModelingService getServiceDescription(String serviceName,
            Tool t) {
        QualifiedServiceName qname = QualifiedServiceName
                .getQualifiedServiceName(serviceName);

        for (ModelingService s : t.getInterface().getService())
            if (qname.serviceName.equals(s.getName()))
                return s;
        
        return null;
    }

    /**
     * 
     * isToolEqual Two tools are considered equal if tool names, interface names
     * and modelling service names match.
     * 
     * @param t1
     * @param t2
     * @return
     * 
     */
    public static boolean isToolEqual(Tool t1, Tool t2) {
        if ((t1.getName().equals(t2.getName()))
                && (t1.getInterface().getName().equals(t2.getInterface()
                        .getName()))) {
        	for (ModelingService testService : t1.getInterface().getService())
        	{
        		ModelingService matchingService = DescriptionUtil
        			.getServiceDescription(testService.getName(), t2);
        		if (matchingService == null)
        			return false;
        	}
        	
            return true;
        }

        return false;
    }
    
    
    public static String getFullServiceName(ModelingService s) {
        ModelingServiceInterface intf = (ModelingServiceInterface) s.eContainer();
        if(intf != null) {
            return intf.getName() +"." + s.getName();
        }
        return s.getName();
    }

    public static List<Parameter> get_in_inout_Parameters(ModelingService ms) {
        DirectionKind[] dk = { DirectionKind.IN_LITERAL,
                DirectionKind.INOUT_LITERAL };
        return getParameters(ms, dk);
    }

    public static List<Parameter> get_out_inout_Parameters(ModelingService ms) {
        DirectionKind[] dk = { DirectionKind.OUT_LITERAL,
                DirectionKind.RETURN_LITERAL, DirectionKind.INOUT_LITERAL };
        return getParameters(ms, dk);
    }

    public static List<Parameter> getInParameters(ModelingService ms) {
        DirectionKind[] dk = { DirectionKind.IN_LITERAL };
        return getParameters(ms, dk);
    }

    public static List<Parameter> getOutParameters(ModelingService ms) {
        DirectionKind[] dk = { DirectionKind.OUT_LITERAL };
        return getParameters(ms, dk);
    }

    public static List<Parameter> getInoutParameters(ModelingService ms) {
        DirectionKind[] dk = { DirectionKind.INOUT_LITERAL };
        return getParameters(ms, dk);
    }

    public static List<Parameter> getParameters(ModelingService ms, DirectionKind[] dk) {
        List<Parameter> result = new Vector<Parameter>();
        for (Parameter p : ms.getParameter())
        	for (int i = 0; i < dk.length; i++)
                if (p.getDirection().equals(dk[i]))
                    result.add(p);
       return result;
    }

    public static Error getError(ModelingService ms, String errorName) {
    	for (Error error : ms.getServiceError())
    		if (error.getName().equals(errorName))
    			return error;
        return null;
    }

    public static Parameter getParameter(ModelingService ms, String paramName) {
    	for (Parameter p : ms.getParameter())
    		if (paramName.equals(p.getName()))
    			return p;
        return null;
    }
    
    /**
     * 
     * converta map (name-value) of parameters to 
     * an array of parameter values
     * 
     * @param params specifies the parameter order
     * @param values
     * @return
     * 
     *
     */
    public static Object[] map2Array(Parameter[] params, Map<String, Object> values) {
        Object[] result = new Object[params.length];
        for(int i=0; i<params.length; i++) {
            result[i] = values.get(params[i].getName());
        }
        return result;
    }
    
    /**
     * convert an array of parameter values to a map (name-value)
     * 
     * array2Map
     * 
     * @param params
     * @param values
     * @return
     * 
     *
     */
    public static Map<String, Object> array2Map(Parameter[] params, Object[] values) {
        Map<String, Object> result = new Hashtable<String, Object>();
        for(int i=0; i<params.length; i++) {
            result.put(params[i].getName(), values[i]);
        }
        return result;        
    }
    
    
    /**
     * 
     * get the Parameter Name List such as 
     * "param1, param2, ..."
     * 
     * @param params
     * @return
     * 
     *
     */
    public static String getParameterNameList(Parameter[] params) {
       String result = null;
       for(int i=0; i<params.length; i++) {
           Parameter p = (Parameter) params[i];
           if(result == null) {
               result = p.getName();
           } else {
               result = result + ", " +p.getName();
           }
       } 
       return result;
    }

    public static String getProperty(Tool t, String propertyName) {
        Iterator it = t.getProperty().iterator();
        while (it.hasNext()) {
            Property p = (Property) it.next();
            String proName = p.getName();
            if (proName!=null && proName.equalsIgnoreCase(propertyName)) {
                return p.getValue();
            }
        }
        return null;
    }

    public static Property getPropertyObject(Tool t, String propertyName) {
        Iterator it = t.getProperty().iterator();
        while (it.hasNext()) {
            Property p = (Property) it.next();
            if (p.getName().equalsIgnoreCase(propertyName)) {
                return p;
            }
        }
        return null;
    }
    
    
    public static String getUrl(Tool t) {
        Property p = getPropertyObject(t, "URL");
        if(p==null) return null;
        return p.getValue();
    }

    public static boolean getIsSessionEnabled(Tool t) {
        String pro = getProperty(t, IS_SESSION_ENABLED);
        if (pro == null)
            return false;
        if (pro.startsWith("true"))
            return true;
        else
            return false;
    }
    
    /**
     * 
     * 
     * Add the external metamodels to the resource of the tool description model.
     * The objective is to allow the external metamodels that are referenced 
     * to be transmitted with the tool description.
     * 
     * 
     * @param t
     * @param ignoredUriPrefixSet
     * 
     *
     */
    public static void importAllMetamodels(Tool t, Collection ignoredUriPrefixSet){
        Resource r = t.eResource();
        Set s = new HashSet();
        s.add(r);
        ModelUtil.addCrossReferencedResources(s, ignoredUriPrefixSet);
        for(Iterator it = s.iterator(); it.hasNext(); ) {
            Resource r2 = (Resource) it.next();
            if(r2!=r) {
              r.getContents().addAll( r2.getContents());
            }
        }

    }

}


