/*
 * $RCSfile: Emf2XmiConversion.java,v $
 * $Date: 2007/06/09 12:03:57 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */


package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.ecore.resource.Resource;

/**
 * Emf2XmiConversion This class is able to convert a collection of EObjects to a String. This
 * string contains the model in XMI2.0 format.
 * 
 * @author Prawee Sriplakich (LIP6)
 * 
 * @version $Revision: 1.1 $ $Date: 2007/06/09 12:03:57 $
 */
public class Emf2XmiConversion {


    static {
        ModelBusResourceSet.init();
    }

    /**
     * Serializes the elements in the collection to a String. The elements that
     * are in the same "Resources" as the elements in the collection will be
     * also serialized. <br>
     * 
     * @param emfobjs
     * @return
     * @throws IOException
     * 
     * 
     */
    public static String convertToString(Collection emfobjs) throws IOException {
        List<Resource> resources = ModelUtil.getResourcesFromObjects(emfobjs, true, 
                GlobalResourceRegistry.GLOBAL_URI_PREFIX_SET);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for(Resource r : resources) {
            r.save(bout, null);
        }
        return bout.toString();
    }




}
