/*
 * $RCSfile: ModelTypeChecker.java,v $ $Date: 2007/06/09 12:03:57 $ $Revision:
 * 1.2 $ $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus. All rights
 * reserved.
 * 
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ModelTypeChecker.java provides methods to verify conformance of ModelType-s
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh, Xavier Blanc (LIP6)
 * 
 * @version $Revision: 1.7 $ $Date: 2007/06/09 12:03:57 $
 *  
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractFactoryImpl;
import org.eclipse.mddi.modelbus.description.abstract_.impl.MetaclassSpecificationImpl;
import org.eclipse.mddi.modelbus.description.abstract_.impl.ModelTypeImpl;

/**
 * 
 * TODO Add description
 *
 */
public class ModelTypeChecker {
    
    
    

    /**
     * isTypeOf Add description
     * 
     * @param model
     * @param modelType
     * @return
     * 
     * @see Add references
     * 
     * TODO Add description
     */
    public static boolean isTypeOf(Collection model, ModelType type) {
        Iterator it = type.getContent().iterator();
        while (it.hasNext()) {
            MetaclassSpecification spec = (MetaclassSpecification) it.next();
            int u = spec.getUpper();
            if (u == -1)
                u = Integer.MAX_VALUE;
            int l = spec.getLower();
            EClass c = spec.getMetaClass();
            Collection instances = ModelUtil
                    .findElementByType_considerSubtypes(model, c);
            int count = instances.size();
            if (count > u || count < l)
                return false;
        }
        return true;
    }

    public static boolean isTypeOf_XB(Collection modelFragment, ModelType type) throws ModelTypeMismatchException {
        ModelTypeChecker.ModelTypeForChecker checkerType = (ModelTypeChecker.ModelTypeForChecker)type;
        
        
        
        boolean res = checkerType.isTypeOf(modelFragment);
        //TODO: remove temporaryModelType (DON'T KNOW HOW)
        return res;
    }

    /**
     * conforms checks conformity of two ModelTypes
     * 
     * @param subtype
     * @param supertype
     * @return
     *  
     */
    public static boolean conforms(ModelType providedType, ModelType requiredType) throws ModelTypeMismatchException{
        return ((ModelTypeChecker.ModelTypeForChecker)providedType).conformsTo((ModelTypeChecker.ModelTypeForChecker)requiredType);
        
    }


    	
    	
    	class ModelTypeForChecker extends ModelTypeImpl{
    	    
    	    Map eclasses = null;//<MetaClass, MetaclassSpecificationForChecker>
                                // to be filled with normalize().
    	    
    	    
    		public boolean conformsTo(ModelTypeForChecker requiredType) throws ModelTypeMismatchException {
    			// Ensure that you remove @generated or mark it @generated NOT
    			normalize();
    			requiredType.normalize();
    			for (Iterator classesSpecificationRequiredTypeIt = requiredType
    					.eclasses.values().iterator(); classesSpecificationRequiredTypeIt
    					.hasNext();) {
    			    ModelTypeChecker.MetaclassSpecificationForChecker currentClassSpecificationRequiredType = (ModelTypeChecker.MetaclassSpecificationForChecker) classesSpecificationRequiredTypeIt
    						.next();
    				//Check all MetaClassSpecification that conform to current
    				Vector conformantClassSpecification = new Vector();
    				for (Iterator classesSpecificationProvidedTypeIt = this
    						.getContent().iterator(); classesSpecificationProvidedTypeIt
    						.hasNext();) {
    					ModelTypeChecker.MetaclassSpecificationForChecker currentClassSpecificationProvidedType = (ModelTypeChecker.MetaclassSpecificationForChecker) classesSpecificationProvidedTypeIt
    							.next();
    					if (currentClassSpecificationProvidedType.conformsTo(
    							currentClassSpecificationRequiredType).booleanValue())
    						conformantClassSpecification
    								.add(currentClassSpecificationProvidedType);
    				}

    				if (conformantClassSpecification.size() == 0)
    					return false;
    				//Check multiplicity
    				int max = 0;
    				int min = 0;
    				for (Iterator it = conformantClassSpecification.iterator(); it
    						.hasNext();) {
    				    ModelTypeChecker.MetaclassSpecificationForChecker currentConformantClassSpecification = (ModelTypeChecker.MetaclassSpecificationForChecker) it
    							.next();
    						if (currentConformantClassSpecification.getSupers()
    								.isEmpty()) {//if Top Level
    							//MAX
    							if (max == -1
    									|| currentConformantClassSpecification
    											.getUpper() == -1)
    								max = -1;
    							else
    								max = +currentConformantClassSpecification
    										.getUpper();
    							//MIN
    							min =+ currentConformantClassSpecification
    									.getLower();
    						}
    				}
    				if (currentClassSpecificationRequiredType.getUpper() != -1) {
    					if (max == -1
    							|| currentClassSpecificationRequiredType
    									.getUpper() < max)
    						return false;
    				} else if (currentClassSpecificationRequiredType.getUpper() > min)
    					return false;
    			}
    			return true;
    		}
    		
    		public boolean isTypeOf(Collection modelFragment) throws ModelTypeMismatchException {
    			// TODO: Ensure that you remove @generated or mark it @generated NOT
    			ModelTypeForChecker temporaryModelType = (ModelTypeForChecker) AbstractFactoryImpl.eINSTANCE
    					.createModelType();
    			Map map = new WeakHashMap(); //contains <EClass, ModelTypeChecker.MetaclassSpecificationForChecker>
    			for (Iterator it = modelFragment.iterator(); it.hasNext();) {
    				EObject current = (EObject) it.next();
    				if (map.containsKey(current.eClass())) {
    				    ModelTypeChecker.MetaclassSpecificationForChecker spec = (ModelTypeChecker.MetaclassSpecificationForChecker) map
    							.get(current.eClass());
    					spec.setUpper(spec.getUpper() + 1);
    					spec.setUpper(spec.getUpper() + 1);
    				} else {
    				    ModelTypeChecker.MetaclassSpecificationForChecker spec = (ModelTypeChecker.MetaclassSpecificationForChecker) AbstractFactoryImpl.eINSTANCE
    							.createMetaclassSpecification();
    					temporaryModelType.getContent().add(spec);
    					spec.setMetaClass(current.eClass());
    					spec.setUpper(1);
    					spec.setLower(1);
    					map.put(current.eClass(), spec);
    				}
    			}
    			boolean res = temporaryModelType.conformsTo(this);
    			//TODO: remove temporaryModelType (DON'T KNOW HOW)
    			return res;
    		}


    	    
    	    public void normalize() throws ModelTypeMismatchException {
    	        // TODO: Ensure that you remove @generated or mark it @generated
                // NOT

    	        //Look if all sub and super links are established
    	        eclasses = new WeakHashMap(); 
    			for (Iterator it = this.getContent().iterator(); it.hasNext();) {
    				ModelTypeChecker.MetaclassSpecificationForChecker current = (MetaclassSpecificationForChecker) it.next();
    				EClass eclass = current.getMetaClass();
    				if (!eclasses.containsKey(eclass))
    					eclasses.put(eclass, current);
    				else
    					throw new ModelTypeMismatchException(
    							"two MetaClassSpecification for one EClass: Forbidden");
    			}
    	        Set eclassSet = eclasses.keySet();
    	        for (Iterator iter = eclassSet.iterator(); iter.hasNext();) {
    	            EClass current = (EClass) iter.next();
    				EList supertypes = current.getESuperTypes();
    				for (Iterator it = supertypes.iterator(); it.hasNext();) {
    					EClass currentSuperType = (EClass) it.next();
    					if (eclasses.containsKey(currentSuperType)) {
    						((ModelTypeChecker.MetaclassSpecificationForChecker) eclasses.get(current)).getSupers()
    								.add(eclasses.get(currentSuperType));
    						((ModelTypeChecker.MetaclassSpecificationForChecker) eclasses.get(currentSuperType))
    								.getSubs().add(eclasses.get(current));
    					}
    				}
    			}

    			//Look if multiplicities are well formed
    			for (Iterator it = eclasses.values().iterator(); it.hasNext();) {
    			    ModelTypeChecker.MetaclassSpecificationForChecker current = (ModelTypeChecker.MetaclassSpecificationForChecker) it.next();
    				int minSub = 0;
    				for (Iterator subs = current.getSubs().iterator(); subs.hasNext();) {
    					minSub = minSub+ ((ModelTypeChecker.MetaclassSpecificationForChecker) subs.next())
    							.getLower();
    				}
    				if (current.getLower() < minSub)
    					throw new ModelTypeMismatchException("Minima are not coherent");
    				for (Iterator supers = current.getSupers().iterator(); supers
    						.hasNext();) {
    					int m = ((ModelTypeChecker.MetaclassSpecificationForChecker) supers.next())
    							.getUpper();
    					if (m != -1) {
    						if (current.getUpper() == -1
    								|| m < current.getUpper())
    							throw new ModelTypeMismatchException("Maxima are not coherent");
    					}
    				}
    			}
    			//throw new UnsupportedOperationException();
    	    }
    	    
    		int minAmongSupers(ModelTypeChecker.MetaclassSpecificationForChecker spec) {
    			int min = spec.getLower();
    			boolean top = false;
    			while (!top) {
    				List supers = spec.getSupers();
    				if (supers.isEmpty())
    					top = true;
    				else {
    					int potentialmin = 0;
    					for (Iterator it = supers.iterator(); it.hasNext();) {
    						potentialmin = potentialmin
    								+ minAmongSupers((ModelTypeChecker.MetaclassSpecificationForChecker) it.next());
    					}
    					if (potentialmin > min)
    						min = potentialmin;
    				}
    			}
    			return min;
    		}


    	}

    	
    	class MetaclassSpecificationForChecker extends MetaclassSpecificationImpl{
    	    List subs = new ArrayList(); //<MetaclassSpecification>,
    	    List supers = new ArrayList(); //<MetaclassSpecification>,
    		/**
             * 
             * conformsTo Add description
             * 
             * @param otherClass
             * @return
             *  
             */

    		public Boolean conformsTo(MetaclassSpecification otherClass) {
    			// TODO: Ensure that you remove @generated or mark it @generated
                // NOT
    			// TODO: Jim change to name + features
    			if (this.getMetaClass() == otherClass.getMetaClass()) return Boolean.TRUE;
    			else if (this.getMetaClass().getEAllSuperTypes().contains(otherClass.getMetaClass())) return Boolean.TRUE;
    			else return Boolean.FALSE;
    		}

    	    
    	            /**
                     * @return Returns the subs.
                     */
            protected synchronized List getSubs() {
                return subs;
            }
            /**
             * @param subs
             *            The subs to set.
             */
            protected synchronized void setSubs(List subs) {
                this.subs = subs;
            }
            /**
             * @return Returns the supers.
             */
            protected synchronized List getSupers() {
                return supers;
            }
            /**
             * @param supers
             *            The supers to set.
             */
            protected synchronized void setSupers(List supers) {
                this.supers = supers;
            }
}

}
