/*
 * $RCSfile: UUIDXMIResourceFactory.java,v $ $Date: 2007/06/09 12:03:57 $ $Revision: 1.3 $ $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus. All rights
 * reserved.
 * 
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * UUIDXMIResourceFactory.java creates resources to read XMI documents with
 * xmi:uuid elements
 * 
 * @author Andrey Sadovykh (LIP6)
 * 
 * @version $Revision: 1.3 $ $Date: 2007/06/09 12:03:57 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

/*
 * UUIDXMIResourceFactory
 *  
 */

public class UUIDXMIResourceFactory extends XMIResourceFactoryImpl {

    
    public static void init() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new UUIDXMIResourceFactory());         
    }
    /**
     *  
     */
    public UUIDXMIResourceFactory() {
        super();
        // TODO Auto-generated constructor stub
    }

    public Resource createResource(URI uri) {
        return new UUIDXMIResourceImpl(uri);
    }

}
