/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 24 mai 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;


/**
 * This class is able to convert a String to a collection of EObject.
 * Each string must contain model elements in XMI2.0 format 
 * 
 * @author Prawee Sriplakich (LIP6)
 * 
 *
 */
public class Xmi2EmfConversion  {

    static {
	    ModelBusResourceSet.init();
    }    


	public Collection convertFromStrings(Collection strings, boolean returnOnlyTopElements) throws IOException {
        ResourceSet rSet = new ModelBusResourceSet();
        Set result = new HashSet();
		Iterator it = strings.iterator();
		int i=0;
		while(it.hasNext()) {
			Resource r = rSet.createResource(URI.createURI("uri"+(i++) +".modelbus"));			    
		    String s = (String) it.next();
		    ByteArrayInputStream bin = new ByteArrayInputStream(s.getBytes());
		    r.load(bin, null);
		    if(returnOnlyTopElements) {
		      result.addAll(r.getContents());
		    } else {
		      result.addAll(ModelUtil.flattenHirachicalCollection(r.getContents())); 
		    }
		}
		return result;
	}
	
	public static Collection convertFromString(String s, boolean returnOnlyTopElements) throws IOException {
        ResourceSet rSet = new ModelBusResourceSet();
		Resource res = rSet.createResource(ModelBusResourceSet.MB_DEFAULT_RES_URI);			    
		ByteArrayInputStream bin = new ByteArrayInputStream(s.getBytes());
		res.load(bin, null);
		Collection result = null;
	    if(returnOnlyTopElements) {
	       result = new Vector(res.getContents());
	    } else {
	       result = ModelUtil.flattenHirachicalCollection(res.getContents());
	    }
		return result;
	}
    
    /**
     * 
     * Read a set of resources encoded in the specified string.
     * The string must have the following format
     *  <modelbus:Model>
     *    <modelbus:Resource uri="uri1"> ....resource content.... <modelbus:Resource>
     *    <modelbus:Resource uri="uri2"> ....resource content.... <modelbus:Resource>
     *    .....
     *  </modelbus:Model>
     * 
     * @return a ResourceSet containing the read resources.
     * 
     *
     */
    public static ResourceSet readResources(String s) {
        ModelBusResourceSet rset = new ModelBusResourceSet();
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(s.getBytes());            
            Document doc = XmiUtil.parseXml(bin);
            NodeList nl = doc.getDocumentElement().getChildNodes();
            for(int i=0; i<nl.getLength(); i++) {
                if(!(nl.item(i) instanceof Element)) break;
                Element resourceElem = (Element) nl.item(i);
                if(!resourceElem.getTagName().equals("modelbus:Resource")) break;
                Resource r = rset.createResource(URI.createURI(resourceElem.getAttribute("uri")));
                bin = new ByteArrayInputStream(resourceElem.getFirstChild().getNodeValue().getBytes());
                r.load(bin, null);
            }
        } catch (SAXException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return rset;
    }
    
    

	
	/**
	 * 
	 * Load a
     *  resource from this file.
	 * Return only top elements object.
	 * 
	 * @param path
	 * @return
	 * @throws IOException
	 * 
	 *
	 */
	public static List loadFromFile(String path) throws IOException {
		ResourceSet rSet = new ModelBusResourceSet();	
		Resource res = rSet.getResource( URI.createFileURI(path), true );		
        res.load( null);	
        return new Vector(res.getContents());
	}

	/**
	 * 
	 * Load resources from a set of files. 
	 * Resources in files can reference each other using a relative file URI. 
	 * Return the ResourceSet contain the loaded resources.
	 * 
	 * @param path
	 * @return
	 * @throws IOException
	 * 
	 *
	 */	
	public static ResourceSet loadFromFiles(String[] paths) throws IOException {
		ResourceSet rSet = new ModelBusResourceSet();
		for(int i=0; i<paths.length; i++) {
			Resource res = rSet.createResource( URI.createFileURI(paths[i]) );		
		}
		for(Iterator it = rSet.getResources().iterator(); it.hasNext();) {
		    Resource res = (Resource) it.next();
	        res.load( null);		    
		}
		return rSet;	    
	}
	
	
	/**
	 * 
	 * Return all EObjects in the file in a flat style.
	 * 
	 * @param path
	 * @return
	 * @throws IOException
	 * 
	 *
	 */
	public static Collection convertFromFile(String path, boolean returnOnlyTopElements) throws IOException {
		Collection topElems = loadFromFile(path);	
		if(returnOnlyTopElements) {
			return topElems;    
		} else {
		    return ModelUtil.flattenHirachicalCollection(topElems);
		}
	}
	
}
