/*
 * $RCSfile: IdTableRegistry.java,v $
 * $Date: 2007/06/09 12:03:57 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * IdTableRegistry.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2007/06/09 12:03:57 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.util.Map;
import java.util.WeakHashMap;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class IdTableRegistry {

    /**
     * This table stores Id of the elements 
     * with no ResourceSet.
     */
    public static final IdTable defaultTable = new IdTable();
    
    /**
     * Map from ResourceSet to ID table
     */
    static Map tableMap = new WeakHashMap();
    
    public static IdTable getIdTable(ResourceSet rs) {
        if(rs==null) {
            return defaultTable;
        }
        IdTable t = (IdTable) tableMap.get(rs);
        if(t==null) {
            t = new IdTable();
            tableMap.put(rs, t);
        }
        return t;
    }
    
    public static IdTable getIdTable(Resource r) {
        return getIdTable(r.getResourceSet());
    }
    
    
    
    public static IdTable getIdTable(EObject o) {
        Resource r = o.eResource();
        if(r == null) {
            return defaultTable;
        }
        IdTable t = getIdTable(r.getResourceSet());
        return t;        
    }
    

    public static String getId(EObject o) {
        return getIdTable(o).getId(o);
    }
    

    
 
    
    
}
