/*
 * $RCSfile: MBXmiResource.java,v $
 * $Date: 2007/06/09 12:03:57 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * MBXmiResource.java
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2007/06/09 12:03:57 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;


public class MBXmiResource extends ResourceImpl {

   
    
    public MBXmiResource(URI uri) {
       super(uri);
    }
    


    protected void doLoad(InputStream in, Map options) throws IOException {
        MBModelDeserializer deser = new MBModelDeserializer(this);
      
        try {
            deser.deserialize(in);
            
            // Debugging
//            ByteArrayOutputStream bout = new ByteArrayOutputStream();
//            save(bout, null);
//            RootLogger.getLogger().log(Level.FINE, this.getURI().toString());
//            RootLogger.getLogger().log(Level.FINE, bout.toString());
            
            
        } catch (Exception e) {
            if(e instanceof IOException) {
                throw (IOException)e;
            }
            RootLogger.getLogger().log(Level.SEVERE, e.toString(), e);
            throw new IOException(e.toString());
        } 
              
    }
    
    
    
    protected void doSave(OutputStream outputStream, Map options) throws IOException {
       MBModelSerializer ser = new MBModelSerializer();
       ser.serializeResource(this, outputStream);
    }    
    

    /**
     * Get the ID of this object by looking at the ID table.
     * If the object is contained by this resource and has no ID,
     * then create a new ID for it.
     * <p>
     * overide method of  Resource 
     */
    public String getURIFragment(EObject eObject) {
       if(eObject.eResource()==this) { 
         return IdTableRegistry.getIdTable(this).getOrCreateId(eObject);
       }
       return IdTableRegistry.getIdTable(this).getId(eObject);
    }

    /* 
     * overide method Resource 
     */    
    public EObject getEObject(String uriFragment) {
        return IdTableRegistry.getIdTable(this).getModelElement(uriFragment);
    }  
    
    
//    /**
//     * Detect the moving of nodes from other resources 
//     * in order to preserve its ID.
//     * See ResourceImpl
//     */
//    public void attached(EObject o) {   
//      super.attached(o);
//      if(!preserveIdWhenMove) {
//          return;
//      }
//      ResourceSet rs = getResourceSet();
//      if(rs==null) { return; }
//      assignIDOfMovedObject(o, rs);
//      for(Iterator it=o.eAllContents(); it.hasNext(); ) {
//          FF
//      }
//      
//
//    }
//    
//    
//    public void assignIDOfMovedObject(EObject o, ResourceSet rs) {
//        for(int i=0; i<rs.getResources().size(); i++) {
//            if(rs.getResources().get(i)!=this && 
//                    rs.getResources().get(i) instanceof MBXmiResource) {
//                MBXmiResource r = (MBXmiResource) rs.getResources().get(i);
//                String id = r.getIdTable().getId(o);
//                if(id!=null) {
//                    this.getIdTable().assignId(id, o);
//                    return;
//                }
//            }
//        }
//    }
//    
//
//    /**
//     * @return Returns the preserveIdforMoving.
//     */
//    public boolean isPreserveIdWhenMove() {
//        return preserveIdWhenMove;
//    }
//
//
//    /**
//     * @param preserveIdforMoving The preserveIdforMoving to set.
//     */
//    public void setPreserveIdWhenMove(boolean preserveIdforMoving) {
//        this.preserveIdWhenMove = preserveIdforMoving;
//    }
//   
    
}
