/*
 * $RCSfile: ModelBaseResourceSet.java,v $
 * $Date: 2007/06/09 12:03:57 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ModelBaseResourceSet.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2007/06/09 12:03:57 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;

/**
 * This resource set manage the resources downloaded from the repository. It can
 * resolve the URI "repository:/..." to the local file environment
 * 
 * @author Prawee Sriplakich (LIP6)
 * 
 * 
 */
public class ModelBaseResourceSet extends ResourceSetImpl {

    public static final String EXTENSION = "modelbase_xmi"; 
    
    static {
        
        MBXmiResourceFactory.init();
        
        Map m = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        m.put(EXTENSION, MBXmiResourceFactory.INSTANCE);  
    }
    
    protected boolean resolveOnDemand = true;
    
//    protected ResourceSetChangeListener listener = new ResourceSetChangeListener();

    /**
     * Create a resource set
     * 
     * @param localEnvironment
     *            Root location storing the modelfiles.
     * @throws IOException 
     * @throws IOException
     *             if the localEnvironment is invalide
     */
    public ModelBaseResourceSet(File localEnvironment) throws IOException {
        // org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"localEnvironmentPath " + localEnvironment);        
        ModelBaseURIConverter c = createURIConverter();
        this.setURIConverter(c);
//        this.eAdapters().add(listener);
        c.setLocalEnvironment(localEnvironment);
    }
    
    
    /**
     * Create a URLConverter for this resource set.
     * Subclass may overide this method to 
     * create a specifialize URI converter.
     * 
     * @return
     */
    protected ModelBaseURIConverter createURIConverter() {
        return new ModelBaseURIConverter();
    }
    

    /**
     * Create a resource that supports the ModelBus serialization
     * (MBXmiResource)
     */
    public Resource createResource(URI uri) {
        URI nuri = getModelBaseURIConverter().normalize(uri); 
        Resource r = null;
        if(EXTENSION.equals(nuri.fileExtension()) || 
                MBXmiResourceFactory.EXTENSION.equals(nuri.fileExtension())) {
            r = MBXmiResourceFactory.INSTANCE.createResource(nuri);
        } else {
            // may return null
            r = super.createResource(nuri);
        }
        if(r==null) {
            r = MBXmiResourceFactory.INSTANCE.createResource(nuri); 
        }
        getResources().add(r);
        return r;
    }

    /*
     * see ResourceSetImpl.
     */
    public EObject getEObject(URI uri, boolean loadOnDemand) {
        Resource resource = null;
        try {
            boolean canLoad = !ModelBaseURIConverter.hasRepositoryScheme(uri)
                                || getModelBaseURIConverter().getLocalEnvironment()!=null;
            resource = getResource(uri.trimFragment(), 
                    loadOnDemand 
                    && resolveOnDemand
                    && canLoad );
            if (resource != null) {
                return resource.getEObject(uri.fragment());
            } 
        } catch (WrappedException e) {
             String exceptionString = (e.exception()==null)? e.toString() : e.exception().toString();
             RootLogger.getLogger().log(Level.FINE, "Resource " + uri.trimFragment() + " not resolved. "
                     +exceptionString);
        } catch (Exception e) {
             RootLogger.getLogger().log(Level.FINE, "Resource " + uri.trimFragment() + " not resolved. " 
                     +e.toString());
        }
        return null;
    }
    
    
    public ModelBaseURIConverter getModelBaseURIConverter() {
        return (ModelBaseURIConverter) this.getURIConverter();
    }


    /**
     * @return Returns the resolveOnDemand.
     */
    public boolean isResolveOnDemand() {
        return resolveOnDemand;
    }


    /**
     * If resolveOnDemand is false,
     * Then the resolution of proxies will not cause new resources to be loaded.
     * The the resolution will be performed for only loaded resources.
     * 
     * @param resolveOnDemand The resolveOnDemand to set.
     */
    public void setResolveOnDemand(boolean resolveOnDemand) {
        this.resolveOnDemand = resolveOnDemand;
    }
    
    
//    /**
//     * Detect the addition of a new resource to this resource set.
//     * Then performs the following actions :
//     * - Normalize its URI, 
//     * 
//     * @author Prawee Sriplakich (Prawee.Sriplakich[at]lip6.fr)
//     *
//     */
//    public class ResourceSetChangeListener extends AdapterImpl {
//
//        /* see Adapter */
//        public void notifyChanged(Notification notif) {
//            if (notif.getNewValue() instanceof Resource) {
//                Resource r = (Resource) notif.getNewValue();
//                URI normUri = getModelBaseURIConverter().normalize(r.getURI());
//                r.setURI(normUri);
//            }
//        }        
//        
//    }
    

}
