package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;

/**
 * 
 * This class manage how to restore the contents of models
 * 
 * @author P. Sriplakich
 * 
 * 
 */
public class RestoreManager {

    // String format = "EMF";

    IdTable originalModelIdTable;

    List<EObject> originalElems = new Vector();

    IdTable receivedModelIdTable;

    List<EObject> receivedElems = new Vector();

    /**
     * Prepare the restoration of models.
     * 
     */
    public RestoreManager() {
    }

    /**
     * Perform the restoration
     * 
     */
    public void update(Resource orgResource, Resource newResource) {

        originalModelIdTable = IdTableRegistry.getIdTable(orgResource);

        receivedModelIdTable = IdTableRegistry.getIdTable(newResource);

        for (Iterator<EObject> it = orgResource.getAllContents(); it.hasNext();) {
            originalElems.add(it.next());
        }

        for (Iterator<EObject> it = newResource.getAllContents(); it.hasNext();) {
            receivedElems.add(it.next());
        }

        Collection<String> originalModelIds = originalModelIdTable
                .getIdsFromFragment(originalElems);

        Collection<String> resultFragmentIds;
        resultFragmentIds = receivedModelIdTable
                .getIdsFromFragment(receivedElems);

        Collection<String> createdElementIds = new HashSet(resultFragmentIds);
        createdElementIds.removeAll(originalModelIds);

        // removedElementIds =
        // originalModelIdTable.getIdsFromFragment(originalFragment);
        // removedElementIds.removeAll(resultFragmentIds);

        Collection<EObject> commonIds = new HashSet(originalModelIds);
        commonIds.retainAll(resultFragmentIds);

        // prevent the element to be garbage collected.
        // This element may be later added inside another element in the resource.
        List<EObject> newElems = new Vector();

        // create new elements.
        for (String id : createdElementIds) {
            EObject updatedElem = receivedModelIdTable.getModelElement(id);
            EClass c = updatedElem.eClass();
            EObject newElem = EcoreUtil.create(c);
            originalModelIdTable.assignId(id, newElem);
            
            newElems.add(newElem);
        }

        // update properties of all elements (existing and added elements)
        for (String id : resultFragmentIds) {
            EObject originalElem = originalModelIdTable.getModelElement(id);
            EObject updatedElem = receivedModelIdTable.getModelElement(id);
            copyElement(originalElem, updatedElem);
        }
        
        // add objects having no parent to the resource
        for(EObject o : newElems) {
            if(o.eResource()==null) {
                orgResource.getContents().add(o);
            }
        }

    }

    // // public Collection getRemovedElementIds() {
    // // return removedElementIds;
    // // }
    // //
    // // public Collection getAddedElements() {
    // // return originalModelIdTable.getFragmentFromIds(addedElementIds);
    // // }
    // //
    // // public Collection getAddedElementIds() {
    // // return addedElementIds;
    // // }
    // //
    // // public Collection getResultFragment() {
    // // return resultFragment;
    // // }
    // //
    // // public Collection getResultFragmentIds() {
    // // return resultFragmentIds;
    // // }

    private void copyElement(EObject originalElem, EObject updatedElem) {

        // copy all attributes
        for (Iterator it = originalElem.eClass().getEAllAttributes().iterator(); it
                .hasNext();) {
            EAttribute a = (EAttribute) it.next();
            if (a.isChangeable() && !a.isDerived()) {
                // Object oldValue = originalElem.eGet(a);
                Object updatedValue = updatedElem.eGet(a);
                // overwrite old value
                originalElem.eSet(a, updatedValue);
            }
        }
        // copy all references
        for (Iterator it = updatedElem.eClass().getEAllReferences().iterator(); it
                .hasNext();) {
            EReference r = (EReference) it.next();
            if (r.isChangeable() && !r.isDerived()) {
                if (r.isMany()) {
                    List<EObject> orgLinkList = (List<EObject>) originalElem
                            .eGet(r);
                    List<EObject> newLinkList = (List<EObject>) updatedElem
                            .eGet(r);

                    orgLinkList.clear();

                    for (int i = 0; i < newLinkList.size(); i++) {
                        EObject org = getMatchOrgElement(newLinkList.get(i));
                        orgLinkList.add(org);
                    }

                } else {
                    // EObject oldLink = (EObject) originalElem.eGet(r);
                    EObject newLink = (EObject) updatedElem.eGet(r);

                    if (newLink != null) {
                        EObject o = getMatchOrgElement(newLink);
                        if (o != null) {
                            originalElem.eSet(r, o);
                        }
                    } else if (r.isUnsettable()) {
                        originalElem.eUnset(r);
                    }
                }
            }

        }
    }

    EObject getMatchOrgElement(EObject newElem) {
        InternalEObject org = null;
        if (newElem.eIsProxy()) {
            return newElem;
        }
        String id = receivedModelIdTable.getId(newElem);
        if (id != null) {
            org = (InternalEObject) originalModelIdTable.getModelElement(id);
            if (org != null) {
                return org;
            }
        }
        URI uri = newElem.eResource().getURI();
        uri = uri.appendFragment(newElem.eResource().getURIFragment(newElem));
        org = (InternalEObject) EcoreUtil.create(newElem.eClass());
        org.eSetProxyURI(uri);
        RootLogger.getLogger().log(Level.INFO, "Proxy created " + uri);
        return org;
    }

}
