/*
 * $RCSfile: ProfiledModelSerializer.java,v $
 * $Date: 2007/06/09 12:03:57 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * ProfiledModelSerializer.java
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2007/06/09 12:03:57 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2;

import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DefaultModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

/**
 * This class can serialize and deserialize UML2 models
 * and the UML2 profiles that are applied to those models 
 * <br>
 * When the profiles are deserialized, 
 * their EPackages are automatically registered with EMF.
 * This enable the models (to which the profiles are applied) 
 * to be deserialized without error.
 * 
 * @author P. Sriplakich
 *
 *
 */
public class ProfiledModelSerializer extends DefaultModelSerializer {


    
    /**
     * 
     */
    public ProfiledModelSerializer() {
        super();
        ignoredUriPrefixSet.add("pathmap://UML2_PROFILES"); 
        ignoredUriPrefixSet.add("pathmap://UML2_LIBRARIES");  
        ignoredUriPrefixSet.add("pathmap://UML2_METAMODELS");
    }    
    
    /*
     * implements ModelSerializer 
     */
    public SerializedXmiDocument[] serialize(List<Parameter> params, Map<String, Object> values) {
        Collection<EObject> allModelElements = getScope(params, values);
        
        sentResources = ModelUtil.getResourcesFromObjects(allModelElements,
                skipCrossReferences, ignoredUriPrefixSet);
        
        ////////////////////////////
        List<Resource> list = new Vector(sentResources);
        sentResources.clear();
        Resource r;
        while((r=getProfileResourceFirst(list))!=null) {
            sentResources.add(r);
        }
        ///////////////////////////////
        
        return serializeResources();
    }

    /*
     * implements ModelSerializer 
     */
    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        DeserializedModel[] result = new DeserializedModel[documents.length];
        ResourceSet rs = new ModelBusResourceSet();
        
        for(int i=0; i<documents.length; i++) {
            result[i] = new DeserializedModel();
            result[i].setUri( documents[i].getUri() );
            try {
               ByteArrayInputStream bin = new ByteArrayInputStream( 
                        documents[i].getXmi().getBytes() );               
               Resource r = rs.createResource( 
                       URI.createURI(documents[i].getUri()) ); 
               r.load(bin, null);
               result[i].setValue(r);
               if(receivedResources==null) {
                   receivedResources = new Vector();
               }
               receivedResources.add(r);
               ///////////////////////////////////////////// 
               Profile p = getContainedProfile(r);
               if(p!=null) {
                 Uml2ModelUtil.registerEcorePackagesOfProfile(p);
               }               
               ////////////////////////////////////////// 
               
            } catch(Exception e) {
                 org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.SEVERE, "", e);
            }
        }
        return result;
    }  
    
    /**
     * 
     * Each time it is called,
     * a resource is removed from the collection
     * and returned.
     * If the collection contains resources representing profiles,
     * those resources will be returned first.
     * 
     * @param v
     * @return
     * 
     *
     */
    Resource getProfileResourceFirst(Collection<Resource> c) {
        for(Resource r : c ) {
          Profile p = getContainedProfile(r);
          if(p!=null) {
              c.remove(r);
              return r;
          }
        }
        if(c.isEmpty()) {
            return null;
        }
        Resource r2 = c.iterator().next();
        c.remove(r2);
        return r2;
    }
    
    
    public static Profile getContainedProfile(Resource r) {
        Profile profile = (Profile) EcoreUtil.getObjectByType(
                r.getContents(), UMLPackage.eINSTANCE.getProfile());
        return profile;
    }
    
    
    
    
    
}
