/*
 * $RCSfile: BasicModelSerializer.java,v $
 * $Date: 2007/06/09 12:03:58 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * BasicModelSerializer.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2007/06/09 12:03:58 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Vector;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;

/**
 * 
 * This class is for testing AbstractBasicModelSerializer
 * 
 * @author P. Sriplakich
 *
 *
 */
public class BasicModelSerializer extends AbstractBasicModelSerializer {

    ResourceSet rs = new ModelBusResourceSet();
    Resource defaultResource;
    
    public BasicModelSerializer() {
        defaultResource = rs.createResource( ModelBusResourceSet.MB_DEFAULT_RES_URI);
    }
    
    protected void serialize(Object o, OutputStream xmiStream) {
        // In this default implementation, 
        // we assume that the object is a collection of model elements.
        Collection model = (Collection) o;
        Resource r = null;
        if(!model.isEmpty()) {
          EObject eo = (EObject) model.iterator().next();
          r = eo.eResource();
        }
        if(r==null) {
            r = defaultResource;
            r.getContents().clear();
            r.getContents().addAll( ModelUtil.getTopElements(model)  ); 
        }
        try {
            r.save(xmiStream, null);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

     protected Object deserialize(InputStream xmiStream) {
        try {
            defaultResource.load(xmiStream , null);
            return defaultResource.getContents();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        // empty model
        return new Vector();
    }


}
