/*
 * $RCSfile: AbstractInvocationSender.java,v $
 * $Date: 2007/06/07 13:33:39 $
 * $Revision: 1.5 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * AbstractInvocationSender.java
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.5 $ $Date: 2007/06/07 13:33:39 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.Marshaler;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public abstract class AbstractInvocationSender implements ProviderProxy {

    private Marshaler marshaler;
    
    private Tool toolDescription;
    /**
     * This property can be derived from the tool description.
     */
    private URL toolUrl;

    /**
     * @return Returns the marshaler.
     */
    public Marshaler getMarshaler() {
        return marshaler;
    }

    /**
     * @param marshaler The marshaler to set.
     */
    public void setMarshaler(Marshaler marshaler) {
        this.marshaler = marshaler;
    }

    /**
     * @return Returns the toolDescription.
     */
    public Tool getToolDescription() {
        return toolDescription;
    }

    /**
     * @param toolDescription The toolDescription to set.
     * @throws ModelBusCommunicationException 
     *          if the URL is invalid
     */
    public void setToolDescription(Tool toolDescription) throws ModelBusCommunicationException {
        this.toolDescription = toolDescription;
        String s = DescriptionUtil.getProperty(toolDescription, "URL");
        try {
            toolUrl = new URL(s);
        } catch (MalformedURLException e) {
            throw new ModelBusCommunicationException(e.toString());
        }
    }


    public URL getToolUrl() {
        return toolUrl;
    }

    /**
     * @param toolUrl The toolUrl to set.
     */
    public void setToolUrl(URL toolUrl) {
        this.toolUrl = toolUrl;
    }
    
    
}
