/*
 * $RCSfile: QualifiedServiceName.java,v $
 * $Date: 2007/04/16 10:44:12 $
 * $Revision: 1.3 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * QualifiedServiceName.java Add description 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.3 $ $Date: 2007/04/16 10:44:12 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

/**
 * 
 * QualifiedServiceName is a container for the full service name.
 * 
 */
public class QualifiedServiceName {
    public String toolName = null;

    public String interfaceName = null;

    public String serviceName = null;

    public boolean equals(QualifiedServiceName qname) {
        if ((this.toolName.equals(qname.toolName))
                && (this.interfaceName.equals(qname.interfaceName))
                && (this.serviceName.equals(qname.serviceName))) {
            return true;
        }
        return false;
    }

    public static QualifiedServiceName getQualifiedServiceName(
            String serviceName) {
        String[] str = serviceName.split("\\.");
        QualifiedServiceName qname = new QualifiedServiceName();
        if (str.length > 0) {
            qname.serviceName = str[str.length - 1];
            if (str.length > 1) {
                qname.interfaceName = str[str.length - 2];
                if (str.length > 2) {
                    qname.toolName = str[str.length - 3];
                }
            }
        } else
        qname.serviceName = serviceName;
        return qname;
    }

    public static boolean isQualified(String serviceName) {
        String[] str = serviceName.split("\\.");
        if (str.length == 3)
            return true;
        return false;
    }

    public static void main(String[] params) {
        String name = "BBB.AAAA";

        QualifiedServiceName qname = QualifiedServiceName
                .getQualifiedServiceName(name);

        System.out.println("service:" + qname.serviceName);
        System.out.println("interface:" + qname.interfaceName);
        System.out.println("tool:" + qname.toolName);

    }

}
