/*
 * $RCSfile: LocalInvocationSender.java,v $
 * $Date: 2007/06/09 12:03:58 $
 * $Revision: 1.5 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * LocalInvocationSender.java
 * 
 * @author Andrey Sadovykh, Nicolas Garandeau (LIP6)
 * @version $Revision: 1.5 $ $Date: 2007/06/09 12:03:58 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.local;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.ProviderEndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.NoAsyncConnectionFoundException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.PollObject;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.ResultNotReadyException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.ThreadPoolQueue;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;


public class LocalInvocationSender extends DefaultWsInvocationSender {


    public LocalInvocationSender() {
        super();
    }

    public void makeConnection() throws SOAPException {

         org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Local Call");

        String relativePath = getToolUrl().getPath();

        ProviderEndPoint ep = (ProviderEndPoint) EndPointManagerImpl
                .getInstance().getEndPoint(relativePath);

         org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Call with Message: "
                + requestMsg.getSOAPBody().toString());

        responseMsg = SoapUtil.messageFactory.createMessage();

        ep.execute(relativePath, requestMsg.getSOAPPart().getEnvelope(),
                responseMsg.getSOAPPart().getEnvelope());

         org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Response Message: "
                + responseMsg.getSOAPBody().toString());

    }
    
    
    //Asyncronous call section
    
	private Map pollObjectMap = null;
	
	public void makeAsyncConnection() throws SOAPException {
		
		 org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Asynchronous Local Call");
		
		if (pollObjectMap==null) pollObjectMap = new HashMap();
		
		String relativePath = getToolUrl().getPath();
		
		ProviderEndPoint ep = (ProviderEndPoint) EndPointManagerImpl
		.getInstance().getEndPoint(relativePath);
		
		 org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Call with Message: "
				+ requestMsg.getSOAPBody().toString());
		
		PollObject po = new PollObject(); 
		
		connectionId = po.hashCode()+"";
		
		pollObjectMap.put(connectionId,po);
		
		runLocalTask(requestMsg,responseMsg,po,relativePath,ep,poolQueue);
		
		connexionId2modelingService.put(connectionId,ms); 
		// to make the ms avaible from the getResult() method, mandatory to unmarshall the message
		
		 org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Response Message: "
				+ responseMsg.getSOAPBody().toString());
		
	}
	
	public void closeAsyncConnection(String connectionId) throws SOAPException, NoAsyncConnectionFoundException{
		// removing the binding connexionId-Ms from the map
		connexionId2modelingService.remove(connectionId);
		
	}
	
	public boolean isResultReady(String connectionId) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException,NoAsyncConnectionFoundException, ModelingServiceError {
		PollObject po = (PollObject) pollObjectMap.get(connectionId);
		return po.isResultReady();
	}
	
	public Object[] getResult(String connectionId) throws ResultNotReadyException, NoAsyncConnectionFoundException, ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
		
		PollObject po;
		
		try {
			po = (PollObject) pollObjectMap.get(connectionId);
		} catch (ClassCastException e1) {
			throw new NoAsyncConnectionFoundException("asynchronous local call - poll object not found in local pollObjectMap");
		}
		
		if (po == null)
			throw new NoAsyncConnectionFoundException("asynchronous local call - poll object not found in local pollObjectMap");
		
		try {
			responseMsg = (SOAPMessage) po.getResult();
			
			// unmarshalling
			ModelingService ms = (ModelingService) connexionId2modelingService.get(connectionId);
			if(ms==null)
				throw new Exception("ModelingService not avaible");
			readResponseMessage();
			
			// the getResultMethod can be called only once
			closeAsyncConnection(connectionId);
			
			//TODO
			//if the queue is empty, we close the threadpool
			if(poolQueue.isEmpty())
				closeThreadPoolQueue();

			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
        Parameter[] outputParams = (Parameter[]) DescriptionUtil.get_out_inout_Parameters(ms).toArray(new Parameter[0]);
        Object[] result = DescriptionUtil.map2Array(outputParams, outputs);
        return result;
	}
	
	
	private static void runLocalTask(SOAPMessage reqMsg,SOAPMessage resMsg,PollObject po,String relativePath,ProviderEndPoint ep,ThreadPoolQueue pool){
		LocalTask task = new LocalTask(reqMsg,resMsg,po,relativePath,ep);
		pool.execute(task);
	}
	
	
	/**
	 * Class responsible for invoking asynchrnously a request message on an endpoint, with a given pollObject
	 */
	private static class LocalTask implements Runnable{
		
		
		private SOAPMessage reqMsg;
		private SOAPMessage resMsg;
		private PollObject po;
		private String relativePath;
		private ProviderEndPoint providerEndPoint;
		
		public LocalTask(SOAPMessage reqMsg, SOAPMessage resMsg, PollObject po,
				String relativePath, ProviderEndPoint providerEndPoint) {
			super();
			this.reqMsg = reqMsg;
			this.resMsg = resMsg;
			this.po = po;
			this.relativePath = relativePath;
			this.providerEndPoint = providerEndPoint;
		}
		
		public void run() {
			try {
				providerEndPoint.execute(relativePath, reqMsg.getSOAPPart().getEnvelope(),
						resMsg.getSOAPPart().getEnvelope());
				po.registerResult(resMsg);
			} catch (SOAPException e) {
				e.printStackTrace();
			}
		}
	}
	


}
