/*
 * $RCSfile: ProviderEndPoint.java,v $ $Date: 2007/04/19 00:44:20 $ $Revision:
 * 1.2 $ $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus. All rights
 * reserved.
 * 
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ProviderEndPoint.java
 * 
 * @author Andrey Sadovykh (LIP6)
 * 
 * @version $Revision: 1.5 $ $Date: 2007/04/19 00:44:20 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.concrete.ConcretePackage;
import org.eclipse.mddi.modelbus.description.concrete.Property;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

/**
 * 
 * This class is the end point for receiving modeling service invocations.
 * It dispatch the invocations to the correspondinf provider tool, according to the request URL.
 * 
 * @author Prawee Sriplakich (LIP6)
 *
 *
 */
public class ProviderEndPoint implements EndPoint {

    /**
     * The relative part that belongs to this EndPoint begins with
     * "modeling_services"
     */
    public static final String DEFAULT_REL_PATH = "modeling_services";


    /**
     * a map that is used for holding the references of the deployed Adapters
     * Each Adapter is associated with a Web Services address (URL). This
     * address allows the Modeling Services provided by the Adapter to be
     * invoked remotely. So, the map contains pairs of addresses and Adapter
     * objects The 'key' element is the address (String URL). The 'value'
     * element is the Adapter object (instance of AdapterStub).
     *  
     */
    private Map relativePath2AdapterMap = new HashMap();

    /**
     * Searches for the Adapter that provides a specified Modeling Service on
     * this server.
     * 
     * @param relativePath
     *            a URI identifying a Modeling Service in this server.
     * @return Adapter object
     */
    public AdapterStub getAdapterOfProviderTool(String relativePath) {
        //  org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Searching for the adapter for :"+relativePath);
        //  org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Get adapter list size="
        // +relativePath2AdapterMap.size());
        if(relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1, relativePath.length());
        }
        AdapterStub ad = (AdapterStub) relativePath2AdapterMap
                .get(relativePath);
        //  org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Found adapter :"+ad);
        return ad;
    }

    /**
     * 
     * manage this adapter so that it can receives service invocation.
     * 
     * @param adapter
     * @throws Exception
     * 
     *  
     */
    public void manageAdapter(AdapterStub adapter) throws Exception {

        setUrlProperty(adapter);

        Tool toolDescription = adapter.getToolDescription();
        if (toolDescription == null) {
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.WARNING, "Adapter: No tool description found.");
            return;
        }

        EndPointManagerImpl.getInstance().putEndPoint(
                ProviderEndPoint.DEFAULT_REL_PATH, this);
        relativePath2AdapterMap.put(getRelativePath(toolDescription), adapter);
    }

    /**
     * 
     * check the tool description contains the property URL If not, creates this
     * property and it put in tool description <br>
     * 
     * @param adapter
     * 
     * @throws Exception
     */
    private void setUrlProperty(AdapterStub adapter) throws Exception {
        Tool toolDescription = adapter.getToolDescription();

        Property pro = DescriptionUtil
                .getPropertyObject(toolDescription, "URL");
        // if the Property does not exist in tool description
        // Then create it and add to the description
        if (pro == null) {
            pro = ConcretePackage.eINSTANCE.getConcreteFactory()
                    .createProperty();
            toolDescription.getProperty().add(pro);
        }
        int port = ServerManager.getModelBusPort(adapter);

        AbstractServer s = ServerManager.getInstance().getServer(port);

        //important if the port is set automatically it can be changed when
        // creating new ModelBus server.
        port = s.getPort();

        pro.setName("URL");
        pro.setValue("http://" + ServerManager.getHost() + ":" + port + "/"
                + s.getContext() + "/" + getRelativePath(toolDescription));
         org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Assign URL to the Provider tool : " + pro.getValue());

    }

    public static String getRelativePath(Tool tool) {
        String path;

        path = ProviderEndPoint.DEFAULT_REL_PATH + "/" + tool.getName();

        return path;
    }

    public static String getRelativePath(String toolName) {
        String path;

        path = ProviderEndPoint.DEFAULT_REL_PATH + "/" + toolName;

        return path;
    }

    public Collection getAdapters() {
        return relativePath2AdapterMap.values();
    }

    public void removeAdapter(AdapterStub adapter) {
        relativePath2AdapterMap.values().remove(adapter);

//        //if no adapters, remove endpoint
//        if (relativePath2AdapterMap.isEmpty()) {
//            EndPointManagerImpl.getInstance().removeEndPoint(
//                    ProviderEndPoint.DEF_REL_PATH);
//             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"No provider endponts");
//        }

    }

    public void execute(String relativePath, SOAPEnvelope req, SOAPEnvelope resp) {
        // String
        // serviceName=AxisEngine.getCurrentMessageContext().getTargetService();
        // String uri="/axis/services/"+serviceName;

        //  org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"relativePath: "+relativePath);

        AdapterStub a = getAdapterOfProviderTool(relativePath);

        if (a != null) {
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,relativePath + " -> " + a);
            // TODO return SessionReceiver for Session Enabled Providers
            a.getTransportManager().createWsInvocationReceiver()
                    .process(req, resp);
        } else {
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.SEVERE, "No Tool bound to the URI " + relativePath);
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Map has the following entries:");
            for (Iterator it = relativePath2AdapterMap.keySet().iterator(); it
                    .hasNext();) {
                 org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, it.next().toString());
            }
            try {
                DefaultWsInvocationReceiver.createSoapFault(resp,
                        "No Tool bound to the URI " + relativePath);
            } catch (SOAPException e) {
                e.printStackTrace();
            }
        }

    }

}
