
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async;

import java.util.Hashtable;
import java.util.Map;


/**
 * @author Nicolas Garandeau (lip6)
 *
 * This class is responsible for registering all asynchronous connections
 */

public class AsyncConnectionManager {
	/**
	 * Design Pattern Singleton
	 */
	private static AsyncConnectionManager instance = new AsyncConnectionManager();
	
	/**
	 * Design Patter Singleton
	 * @return the instance of AsyncConnectionManager
	 */
	public static AsyncConnectionManager getInstance(){
		return instance;
	}
	
	/**
	 *  The map which register all asynccronous connections:  (connectionID,connection)*
	 */
	private  Map asyncConnectionMap;
	
	
	/**
	 * This constructor instanciates a map to register all asynchronous connections
	 */
	private AsyncConnectionManager(){
		asyncConnectionMap = new Hashtable();
	}
	
	/**
	 * @param id is the connection identifier
	 * @param con is the asynchronous connection 
	 * 
	 * This method puts in the AsyncConnectionManager's map the asynchronous connection with
	 * the given ID.
	 */
	public void putAsyncConnection(String id,SOAPAsyncConnection con){
		
		asyncConnectionMap.put(id,con);
	}
	
	
	/**
	 * @param id is the connection identifier
	 *  This method removes the asynchronous connection corresponding to the ID from the AsyncConnectionManager's map
	 */
	public void removeAsyncConnection(String id){
		asyncConnectionMap.remove(id);
	}
	
	
	/**
	 * @param id is the connection identifier
	 * @return the asynchronous connection corresponding to the ID
	 * @throws NoAsyncConnectionFoundException thrown if there is 
	 * no asynchronous connection corresponding to the ID in the map
	 */
	public SOAPAsyncConnection getAsyncConnection(String id) throws NoAsyncConnectionFoundException{	
		
		Object obj = asyncConnectionMap.get(id);
		
		if(obj != null && obj instanceof SOAPAsyncConnection){
			return (SOAPAsyncConnection)obj;
		}
		
		throw new NoAsyncConnectionFoundException(id+" not found in AsyncConnectionManager");
		
	}
}


