/*
 * $RCSfile: SimpleModelBusServer.java,v $ $Date: 2007/04/19 00:44:21 $
 * $Revision: 1.3 $ $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus. All rights
 * reserved.
 * 
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * SimpleModelBusServer.java
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * 
 * @version $Revision: 1.3 $ $Date: 2007/04/19 00:44:21 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.axis;

import java.net.ServerSocket;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;

import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.SimpleAxisServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.SoapUtil;

public class SimpleModelBusServer extends SimpleAxisServer implements
        AbstractServer {


    EngineConfigurationImpl config = new EngineConfigurationImpl();

    EndPointManager endPointManager;

    AxisServer internalAxisServer;

    int port;

    ServerSocket socket = null;

    String context = ServerManager.DEFAULT_CONTEXT;

    public SimpleModelBusServer(int port) throws Exception {
        this.port = port;
        this.setMyConfig(config);
        internalAxisServer = new MBAxisServer(config);

        startSimpleModelBusServer();

    }

    private void startSimpleModelBusServer() {
        int count = 0;
        boolean isStarted = false;
        while (count < 10 && !isStarted) {
            try {
                socket = new ServerSocket(port);
                setServerSocket(socket);
                start();
                RootLogger.getLogger().log(Level.INFO, "Stared on " + port);
                isStarted = true;

            } catch (Exception e) {
                RootLogger.getLogger().log(Level.INFO, "port not free " + port +" " +e);
                count++;
                port++;
            }
        }
    }

    /**
     * 
     * Implementation of the operation of AbstractServer
     * 
     * @throws Exception
     * 
     */
    public void setEndPointManager(EndPointManager endPointManager) {
        this.endPointManager = endPointManager;
    }

    /**
     * Overide the axis method
     */
    public synchronized AxisServer getAxisServer() {
        return internalAxisServer;
    }

    /**
     * This is a server that dispatches service invocation to ModelBus
     * 
     * 
     * @author P. Sriplakich
     * 
     */
    class MBAxisServer extends AxisServer {
        /**
         * 
         */
        private static final long serialVersionUID = 2422416854888267679L;

        MBAxisServer(EngineConfiguration config) {
            super(config);
        }

        public void invoke(MessageContext msgContext) throws AxisFault {

            String urlPath = (String) msgContext.getProperty("path");
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "Receiving a request : URL = " + urlPath);

            String relativePath = "";
            if (urlPath.startsWith(context + "/")) {
                relativePath = urlPath.replaceFirst(context + "/", "");
            }
            //  org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"relative path = " + relativePath);

            if (endPointManager == null) {
                 org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.SEVERE, "No EndPointManager");
                return;
            }
            try {
                Message req = msgContext.getRequestMessage();

                Message resp = (Message) SoapUtil.messageFactory
                        .createMessage();

                endPointManager.execute(relativePath, req.getSOAPEnvelope(),
                        resp.getSOAPEnvelope());

                msgContext.setResponseMessage(resp);

            } catch (SOAPException e) {
                e.printStackTrace();
            }

        }
    }

    class EngineConfigurationImpl implements EngineConfiguration {

        Hashtable globalOptions = new Hashtable();

        List deployedServices = new Vector();


        public void configureEngine(AxisEngine engine)
                throws ConfigurationException {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "configureEngine()");
        }

        public void writeEngineConfig(AxisEngine engine)
                throws ConfigurationException {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "writeEngineConfig()");
        }

        public Handler getHandler(QName qname) throws ConfigurationException {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "getHandler()");
            return null;
        }

        public SOAPService getService(QName qname)
                throws ConfigurationException {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "getService()");
            return null;
        }

        public SOAPService getServiceByNamespaceURI(String namespace)
                throws ConfigurationException {
            // TODO Auto-generated method stub
            //  org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"getServiceByNamespaceURI()");
            return null;
        }

        public Handler getTransport(QName qname) throws ConfigurationException {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "getTransport()");
            return null;
        }

        public TypeMappingRegistry getTypeMappingRegistry()
                throws ConfigurationException {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "getTypeMappingRegistry()");
            return null;
        }

        public Handler getGlobalRequest() throws ConfigurationException {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "getGlobalRequest()");
            return null;
        }

        public Handler getGlobalResponse() throws ConfigurationException {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "getGlobalResponse()");
            return null;
        }

        public Hashtable getGlobalOptions() throws ConfigurationException {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "getGlobalOptions()");
            return globalOptions;
        }

        public Iterator getDeployedServices() throws ConfigurationException {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "getDeployedServices()");
            // new Exception().printStackTrace();
            return deployedServices.iterator();
        }

        public List getRoles() {
            // TODO Auto-generated method stub
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, "getRoles()");
            return new Vector();
        }

    }

    public int getPort() {
        return port;
    }

    public String getContext() {
        return context;
    }

    /**
     * @param context
     *            The context to set.
     */
    public void setContext(String context) {
        this.context = context;
    }

}
