package org.eclipse.mddi.modelbus.adapter.user.impl;

import java.util.Properties;

import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ConcreteModelingService;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

/**
 * 
 * 
 * @author Alexis Muller
 */
public class ConcreteModelingServiceImpl implements ConcreteModelingService
{
	protected Tool tool;
	protected ModelingServiceInterface inter;
	protected ModelingService service;
	protected AdapterStub adapter;
	
	public ConcreteModelingServiceImpl(Tool tool, ModelingServiceInterface inter,
    		ModelingService service, Properties p) throws DeploymentException
	{
		this.tool = tool;
		this.inter = inter;
        this.service = service;
        
        adapter = new AdapterStubImpl(p);
	}

	public Object[] call(Object[] params) throws ModelingServiceError, ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException {
		return adapter.getGenericConsumer().consume(tool.getName() + "." + inter.getName()
        		+ "." + service.getName(), params);
	}

	public String getName()
	{
		return service.getName();
	}
}