/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 24 mai 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.user.provider;

import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;


/**
 *  	
 * This is an interface offerred by the Tool component.
 * This interface allows the provider tool to receive 
 * a sessionless service invocation from its adapter. 
 *  
 * @deprecated use GenericProvider2
 * 
 * @author Prawee Sriplakich (LIP6)
 *
 */
public interface GenericProvider {

	    /**
	     * Asks the provider tool to perform the specified Modeling Service in the sessionless style. 
	     * The parameter values are represented as Java objects according 
	     * to the same mappings as defined in 
	     * <code>org.eclipse.mddi.modelbus.adapter.GenericServiceInvocation</code> 
	     * 
	     * @param serviceName
	     * @param parameterValues
	     * @return
	     * @throws SessionNeeded
	     * @throws ModelingServiceError an error that is produced by the provider tools during service execution.
	     */
	    Object[] execute(String serviceName,Object[]  parameterValues) throws SessionNeeded, ModelingServiceError; 	

}
