/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 6 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.user.provider;

import org.eclipse.mddi.modelbus.adapter.user.InvalidSession;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;

/**
 * This is an interface offerred by the Tool component.
 * This interface allows the provider tool to receive 
 * a sessionful service invocation from its adapter. 
 * 
 *  * @author Prawee Sriplakich (LIP6)
 *
 */
public interface GenericSessionProvider {

	/**
	 * Asks the provider tool to perform the specified Modeling Service in the sessionful style. 
	 * The parameter values are represented as Java objects according 
	 * to the same mappings as defined in 
	 * <code>org.eclipse.mddi.modelbus.adapter.GenericServiceInvocation</code> 
	 * 
	 * @param serviceName
	 * @param parameterValues
	 * @param sessionID
	 * @return
	 * @throws InvalidSession
	 * @throws ModelingServiceError an error that is produced by the provider tools during service execution.
	 */
	Object[] executeSession(String serviceName,Object[]  parameterValues, String sessionID) 
		throws InvalidSession, ModelingServiceError;

	/**
	 * This operation is used for telling the provider Tool to create state information associated to a session. 
	 * Once the session is started, a sequence of service invocations can be made within the context of this session. 
	 * The session is identified by a session ID which is returned by this operation. 
	 * Later, this ID is sent together with service invocations that are in the context of this session.
	 * This state information is preserved for a period of time (determine by the provider Tool) 
	 * or until the stopSession operation is explicitly invoked (see below). 
	 * 
	 * @return sessionID
	 */
	String newSession();

	
	
	/**
	 * This operation is used for telling the provider Tool 
	 * to destroy the state information associated with this session. 
	 * Then, the session ID becomes invalid. 
	 * It means that this session id can no longer be used for invoking modelling services. 
	 * 
	 * @param sessionID
	 */
	void endSession(String sessionID) throws InvalidSession;

}
