/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RootLogger {
    private static Logger logger;

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("org.eclipse.mddi.modelbus");
            ConsoleHandler h = new ConsoleHandler();
            h.setFormatter(new ShortFormatter());
            h.setLevel(Level.ALL);
            logger.addHandler(h);
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.ALL);
            org.apache.log4j.Logger.getRootLogger().setLevel(org.apache.log4j.Level.FATAL);
            RootLogger.getLogger().log(Level.FINE, "Logger configured");
        }
        return logger;
    }

    static class ShortFormatter
    extends Formatter {
        static final String prefix = "org.eclipse.mddi.modelbus.";

        ShortFormatter() {
        }

        public String format(LogRecord record) {
            StringBuffer sb = new StringBuffer();
            if (record.getSourceClassName() != null) {
                String clazz = record.getSourceClassName();
                if (clazz.startsWith(prefix)) {
                    clazz = clazz.substring(prefix.length());
                }
                sb.append(clazz);
            } else {
                sb.append(record.getLoggerName());
            }
            sb.append(" ");
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            String message = record.getMessage();
            sb.append(message);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(" ");
                    sb.append(sw.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sb.append("\n");
            return sb.toString();
        }
    }
}

