/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractFactoryImpl;
import org.eclipse.mddi.modelbus.description.abstract_.impl.MetaclassSpecificationImpl;
import org.eclipse.mddi.modelbus.description.abstract_.impl.ModelTypeImpl;

public class ModelTypeChecker {
    public static boolean isTypeOf(Collection model, ModelType type) {
        for (MetaclassSpecification spec : type.getContent()) {
            int u = spec.getUpper();
            if (u == -1) {
                u = Integer.MAX_VALUE;
            }
            int l = spec.getLower();
            EClass c = spec.getMetaClass();
            Collection instances = ModelUtil.findElementByType_considerSubtypes(model, c);
            int count = instances.size();
            if (count <= u && count >= l) continue;
            return false;
        }
        return true;
    }

    public static boolean isTypeOf_XB(Collection modelFragment, ModelType type) throws ModelTypeMismatchException {
        ModelTypeForChecker checkerType = (ModelTypeForChecker)type;
        boolean res = checkerType.isTypeOf(modelFragment);
        return res;
    }

    public static boolean conforms(ModelType providedType, ModelType requiredType) throws ModelTypeMismatchException {
        return ((ModelTypeForChecker)providedType).conformsTo((ModelTypeForChecker)requiredType);
    }

    class MetaclassSpecificationForChecker
    extends MetaclassSpecificationImpl {
        List subs = new ArrayList();
        List supers = new ArrayList();

        MetaclassSpecificationForChecker() {
        }

        public Boolean conformsTo(MetaclassSpecification otherClass) {
            if (this.getMetaClass() == otherClass.getMetaClass()) {
                return Boolean.TRUE;
            }
            if (this.getMetaClass().getEAllSuperTypes().contains((Object)otherClass.getMetaClass())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        protected synchronized List getSubs() {
            return this.subs;
        }

        protected synchronized void setSubs(List subs) {
            this.subs = subs;
        }

        protected synchronized List getSupers() {
            return this.supers;
        }

        protected synchronized void setSupers(List supers) {
            this.supers = supers;
        }
    }

    class ModelTypeForChecker
    extends ModelTypeImpl {
        Map eclasses = null;

        ModelTypeForChecker() {
        }

        public boolean conformsTo(ModelTypeForChecker requiredType) throws ModelTypeMismatchException {
            this.normalize();
            requiredType.normalize();
            for (MetaclassSpecificationForChecker currentClassSpecificationRequiredType : requiredType.eclasses.values()) {
                Vector<MetaclassSpecificationForChecker> conformantClassSpecification = new Vector<MetaclassSpecificationForChecker>();
                for (MetaclassSpecificationForChecker currentClassSpecificationProvidedType : this.getContent()) {
                    if (!currentClassSpecificationProvidedType.conformsTo((MetaclassSpecification)currentClassSpecificationRequiredType).booleanValue()) continue;
                    conformantClassSpecification.add(currentClassSpecificationProvidedType);
                }
                if (conformantClassSpecification.size() == 0) {
                    return false;
                }
                int max = 0;
                int min = 0;
                for (MetaclassSpecificationForChecker currentConformantClassSpecification : conformantClassSpecification) {
                    if (!currentConformantClassSpecification.getSupers().isEmpty()) continue;
                    max = max == -1 || currentConformantClassSpecification.getUpper() == -1 ? -1 : currentConformantClassSpecification.getUpper();
                    min = currentConformantClassSpecification.getLower();
                }
                if (!(currentClassSpecificationRequiredType.getUpper() != -1 ? max == -1 || currentClassSpecificationRequiredType.getUpper() < max : currentClassSpecificationRequiredType.getUpper() > min)) continue;
                return false;
            }
            return true;
        }

        public boolean isTypeOf(Collection modelFragment) throws ModelTypeMismatchException {
            ModelTypeForChecker temporaryModelType = (ModelTypeForChecker)AbstractFactoryImpl.eINSTANCE.createModelType();
            WeakHashMap<EClass, MetaclassSpecificationForChecker> map = new WeakHashMap<EClass, MetaclassSpecificationForChecker>();
            for (EObject current : modelFragment) {
                MetaclassSpecificationForChecker spec;
                if (map.containsKey(current.eClass())) {
                    spec = (MetaclassSpecificationForChecker)((Object)map.get(current.eClass()));
                    spec.setUpper(spec.getUpper() + 1);
                    spec.setUpper(spec.getUpper() + 1);
                    continue;
                }
                spec = (MetaclassSpecificationForChecker)AbstractFactoryImpl.eINSTANCE.createMetaclassSpecification();
                temporaryModelType.getContent().add((Object)spec);
                spec.setMetaClass(current.eClass());
                spec.setUpper(1);
                spec.setLower(1);
                map.put(current.eClass(), spec);
            }
            boolean res = temporaryModelType.conformsTo(this);
            return res;
        }

        public void normalize() throws ModelTypeMismatchException {
            this.eclasses = new WeakHashMap();
            for (MetaclassSpecificationForChecker current : this.getContent()) {
                EClass eclass = current.getMetaClass();
                if (!this.eclasses.containsKey(eclass)) {
                    this.eclasses.put(eclass, current);
                    continue;
                }
                throw new ModelTypeMismatchException("two MetaClassSpecification for one EClass: Forbidden");
            }
            Set eclassSet = this.eclasses.keySet();
            for (Object current : eclassSet) {
                EList supertypes = current.getESuperTypes();
                for (EClass currentSuperType : supertypes) {
                    if (!this.eclasses.containsKey(currentSuperType)) continue;
                    ((MetaclassSpecificationForChecker)((Object)this.eclasses.get(current))).getSupers().add(this.eclasses.get(currentSuperType));
                    ((MetaclassSpecificationForChecker)((Object)this.eclasses.get(currentSuperType))).getSubs().add(this.eclasses.get(current));
                }
            }
            for (Object current : this.eclasses.values()) {
                int minSub = 0;
                Iterator subs = ((MetaclassSpecificationForChecker)((Object)current)).getSubs().iterator();
                while (subs.hasNext()) {
                    minSub += ((MetaclassSpecificationForChecker)((Object)subs.next())).getLower();
                }
                if (current.getLower() < minSub) {
                    throw new ModelTypeMismatchException("Minima are not coherent");
                }
                Iterator supers = ((MetaclassSpecificationForChecker)((Object)current)).getSupers().iterator();
                while (supers.hasNext()) {
                    int m = ((MetaclassSpecificationForChecker)((Object)supers.next())).getUpper();
                    if (m == -1 || current.getUpper() != -1 && m >= current.getUpper()) continue;
                    throw new ModelTypeMismatchException("Maxima are not coherent");
                }
            }
        }

        int minAmongSupers(MetaclassSpecificationForChecker spec) {
            int min = spec.getLower();
            boolean top = false;
            while (!top) {
                List supers = spec.getSupers();
                if (supers.isEmpty()) {
                    top = true;
                    continue;
                }
                int potentialmin = 0;
                Iterator it = supers.iterator();
                while (it.hasNext()) {
                    potentialmin += this.minAmongSupers((MetaclassSpecificationForChecker)((Object)it.next()));
                }
                if (potentialmin <= min) continue;
                min = potentialmin;
            }
            return min;
        }
    }
}

