/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.XmiUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Xmi2EmfConversion {
    static {
        ModelBusResourceSet.init();
    }

    public Collection convertFromStrings(Collection strings, boolean returnOnlyTopElements) throws IOException {
        ModelBusResourceSet rSet = new ModelBusResourceSet();
        HashSet result = new HashSet();
        Iterator it = strings.iterator();
        int i = 0;
        while (it.hasNext()) {
            Resource r = rSet.createResource(URI.createURI((String)("uri" + i++ + ".modelbus")));
            String s = (String)it.next();
            ByteArrayInputStream bin = new ByteArrayInputStream(s.getBytes());
            r.load((InputStream)bin, null);
            if (returnOnlyTopElements) {
                result.addAll(r.getContents());
                continue;
            }
            result.addAll(ModelUtil.flattenHirachicalCollection((Collection)r.getContents()));
        }
        return result;
    }

    public static Collection convertFromString(String s, boolean returnOnlyTopElements) throws IOException {
        ModelBusResourceSet rSet = new ModelBusResourceSet();
        Resource res = rSet.createResource(ModelBusResourceSet.MB_DEFAULT_RES_URI);
        ByteArrayInputStream bin = new ByteArrayInputStream(s.getBytes());
        res.load((InputStream)bin, null);
        Vector result = null;
        result = returnOnlyTopElements ? new Vector(res.getContents()) : ModelUtil.flattenHirachicalCollection((Collection)res.getContents());
        return result;
    }

    public static ResourceSet readResources(String s) {
        ModelBusResourceSet rset = new ModelBusResourceSet();
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(s.getBytes());
            Document doc = XmiUtil.parseXml(bin);
            NodeList nl = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Element resourceElem;
                if (nl.item(i) instanceof Element && (resourceElem = (Element)nl.item(i)).getTagName().equals("modelbus:Resource")) {
                    Resource r = rset.createResource(URI.createURI((String)resourceElem.getAttribute("uri")));
                    bin = new ByteArrayInputStream(resourceElem.getFirstChild().getNodeValue().getBytes());
                    r.load((InputStream)bin, null);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rset;
    }

    public static List loadFromFile(String path) throws IOException {
        ModelBusResourceSet rSet = new ModelBusResourceSet();
        Resource res = rSet.getResource(URI.createFileURI((String)path), true);
        res.load(null);
        return new Vector(res.getContents());
    }

    public static ResourceSet loadFromFiles(String[] paths) throws IOException {
        ModelBusResourceSet rSet = new ModelBusResourceSet();
        int i = 0;
        while (i < paths.length) {
            Resource resource = rSet.createResource(URI.createFileURI((String)paths[i]));
            ++i;
        }
        for (Resource res : rSet.getResources()) {
            res.load(null);
        }
        return rSet;
    }

    public static Collection convertFromFile(String path, boolean returnOnlyTopElements) throws IOException {
        List topElems = Xmi2EmfConversion.loadFromFile(path);
        if (returnOnlyTopElements) {
            return topElems;
        }
        return ModelUtil.flattenHirachicalCollection(topElems);
    }
}

