/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.XmiUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.IdTable;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.IdTableRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.MBXmiResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MBModelDeserializer {
    public static final String XMI_NS = "http://www.omg.org/XMI";
    public static DocumentBuilder docBuilder = null;
    String format = "EMF";
    Resource resource;
    IdTable idTable = null;
    Collection createdModelElements = new Vector();
    List links = new Vector();

    static {
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException("XML Parser cannot be initialized", e);
        }
    }

    EClass getType(Element xmlElem) throws IOException {
        String typeString = null;
        typeString = xmlElem.hasAttribute("xmi:type") ? xmlElem.getAttribute("xmi:type") : xmlElem.getTagName();
        String prefix = MBModelDeserializer.getNsPrefix(typeString);
        String className = MBModelDeserializer.getLocalName(typeString);
        String uri = MBModelDeserializer.lookupNamespace(xmlElem, prefix);
        EPackage p = this.getPackageFromURI(uri);
        if (p == null) {
            throw new IOException("PackageNotFound uri=" + uri + " element=" + xmlElem);
        }
        EClass c = (EClass)p.getEClassifier(className);
        if (c == null) {
            throw new IOException("ClassNotFound " + className + "element=" + xmlElem);
        }
        return c;
    }

    public MBModelDeserializer() {
        this((Resource)new MBXmiResource(URI.createURI((String)"uri1")));
    }

    public MBModelDeserializer(Resource r) {
        this.resource = r;
        this.idTable = IdTableRegistry.getIdTable(r.getResourceSet());
    }

    public void deserialize(InputStream in) throws SAXException, IOException {
        Document doc = XmiUtil.parseXml(in);
        this.createModelElementsFromRootXml(doc.getDocumentElement());
        this.resolveLinks(this.links, this.resource);
    }

    public void deserialize(String xmi) throws SAXException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(xmi.getBytes());
        this.deserialize(in);
    }

    public void createModelElementsFromRootXml(Element rootElem) throws IOException {
        String tag = MBModelDeserializer.getLocalName(rootElem.getTagName());
        if (!tag.equals("XMI")) {
            throw new IOException("Expected xmi:XMI element at root. Please check the XMI format " + this.resource.getURI());
        }
        NodeList list = rootElem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                Element xmlElem = (Element)list.item(i);
                EObject o = this.createModelElementFrom(xmlElem);
                this.resource.getContents().add((Object)o);
            }
            ++i;
        }
    }

    EObject createModelElementFrom(Element xmlElem) throws IOException {
        EClass c = this.getType(xmlElem);
        EObject o = EcoreUtil.create((EClass)c);
        this.createdModelElements.add(o);
        String xmiid = xmlElem.getAttribute("xmi:id");
        if (xmiid.equals("")) {
            MBModelDeserializer.printErrMessage("No id for " + xmlElem);
        } else {
            this.idTable.assignId(xmiid, o);
        }
        this.setFeatures(o, xmlElem);
        return o;
    }

    EPackage getPackageFromURI(String uri) {
        EPackage p = EPackage.Registry.INSTANCE.getEPackage(uri);
        if (p == null) {
            try {
                Resource r = this.resource.getResourceSet().getResource(URI.createURI((String)uri), true);
                ModelUtil.registerEPackages(r);
                p = EPackage.Registry.INSTANCE.getEPackage(uri);
            }
            catch (Exception e) {
                RootLogger.getLogger().log(Level.SEVERE, "Package not found " + uri + " " + e);
                return null;
            }
        }
        return p;
    }

    void setFeatures(EObject o, Element xmlElem) throws IOException {
        Object value;
        EClass c = o.eClass();
        NamedNodeMap map = xmlElem.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Node n = map.item(i);
            String attName = n.getNodeName();
            String attNsPrefix = MBModelDeserializer.getNsPrefix(attName);
            String attLocalName = MBModelDeserializer.getLocalName(attName);
            String attValue = n.getNodeValue();
            if (attNsPrefix.length() > 0) {
                if (!attName.equals("xmi:id") && !attName.equals("xmi:type")) {
                    MBModelDeserializer.printErrMessage("Unknown attribute " + attName);
                }
            } else {
                EAttribute watt = (EAttribute)c.getEStructuralFeature(attName);
                if (watt == null) {
                    MBModelDeserializer.printErrMessage("Unknown attribute " + attName);
                } else {
                    value = EcoreUtil.createFromString((EDataType)watt.getEAttributeType(), (String)attValue);
                    o.eSet((EStructuralFeature)watt, value);
                }
            }
            ++i;
        }
        NodeList list = xmlElem.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            if (list.item(i2) instanceof Element) {
                Element subXmlElem = (Element)list.item(i2);
                String elemName = subXmlElem.getTagName();
                EStructuralFeature f = c.getEStructuralFeature(elemName);
                if (f == null) {
                    MBModelDeserializer.printErrMessage("Unknown feature " + elemName);
                }
                if (f instanceof EAttribute) {
                    EAttribute watt = (EAttribute)f;
                    String text = subXmlElem.getFirstChild().getNodeValue();
                    value = EcoreUtil.createFromString((EDataType)watt.getEAttributeType(), (String)text);
                    if (watt.isMany()) {
                        List l = (List)o.eGet((EStructuralFeature)watt, false);
                        l.add(value);
                    } else {
                        o.eSet((EStructuralFeature)watt, value);
                    }
                } else if (f instanceof EReference) {
                    EReference r = (EReference)f;
                    if (subXmlElem.hasAttribute("xmi:action") && subXmlElem.hasAttribute("href")) {
                        this.updateReference(o, r, subXmlElem);
                    } else if (subXmlElem.hasAttribute("href")) {
                        String idref = subXmlElem.getAttribute("href");
                        EClass type = this.getType(subXmlElem);
                        this.links.add(new Link(r, o, idref, type));
                    } else {
                        EObject value2 = this.createModelElementFrom(subXmlElem);
                        if (r.isMany()) {
                            List l = (List)o.eGet((EStructuralFeature)r);
                            l.add(value2);
                        } else {
                            o.eSet((EStructuralFeature)r, (Object)value2);
                        }
                    }
                }
            }
            ++i2;
        }
    }

    void updateReference(EObject o, EReference r, Element refXmlElem) {
        String action = refXmlElem.getAttribute("xmi:action");
        String id = refXmlElem.getAttribute("href");
        EObject referencedElem = this.resource.getEObject(id);
        List l = (List)o.eGet((EStructuralFeature)r, false);
        if (action.equals("add")) {
            l.add(referencedElem);
        } else if (action.equals("remove")) {
            l.remove(referencedElem);
        }
    }

    static String getNsPrefix(String colontag) {
        return colontag.indexOf(58) < 0 ? "" : colontag.substring(0, colontag.indexOf(58));
    }

    static String getLocalName(String colontag) {
        return colontag.substring(colontag.indexOf(58) + 1);
    }

    static String lookupNamespace(Element xmlElem, String prefix) {
        String attName = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        Element topElem = xmlElem;
        String uri = topElem.getAttribute(attName);
        while (uri.equals("") && topElem.getParentNode() instanceof Element) {
            topElem = (Element)topElem.getParentNode();
            uri = topElem.getAttribute("xmlns:" + prefix);
        }
        return uri;
    }

    static void printErrMessage(String s) {
        RootLogger.getLogger().log(Level.SEVERE, s);
    }

    public Collection getCreatedModelElements() {
        return this.createdModelElements;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    void resolveLinks(Collection links, Resource res) throws IOException {
        for (Link link : links) {
            String id = MBModelDeserializer.getIdPart(link.href);
            String uri = MBModelDeserializer.getUriPart(link.href);
            EObject value = null;
            if (uri == null || this.resource.getURI().toString().equals(uri)) {
                value = this.resource.getEObject(id);
                if (value == null) {
                    value = IdTableRegistry.getIdTable(this.resource).getModelElement(id);
                }
            } else {
                value = EcoreUtil.create((EClass)link.type);
                ((InternalEObject)value).eSetProxyURI(URI.createURI((String)link.href));
            }
            if (value == null) {
                RootLogger.getLogger().log(Level.SEVERE, "Invalid href " + link.href);
                continue;
            }
            if (link.eReference.isMany()) {
                List values = (List)link.owner.eGet((EStructuralFeature)link.eReference, false);
                values.add(value);
                continue;
            }
            link.owner.eSet((EStructuralFeature)link.eReference, (Object)value);
        }
        links.clear();
    }

    public static String getUriPart(String href) {
        int i = href.indexOf(35);
        if (i == -1) {
            return null;
        }
        return href.substring(0, i);
    }

    public static String getIdPart(String href) {
        int i = href.indexOf(35);
        if (i == -1) {
            return href;
        }
        return href.substring(i + 1, href.length());
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(MBXmiResource resource) {
        this.resource = resource;
    }

    static class Link {
        EReference eReference;
        EObject owner;
        String href;
        EClass type;

        Link(EReference r, EObject owner, String href, EClass type) {
            this.eReference = r;
            this.owner = owner;
            this.href = href;
            this.type = type;
        }
    }
}

