/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.notification;

import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.SerializedNotification;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.user.notification.Notification;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationConsumer;

public class NotificationEndPoint
implements EndPoint {
    public static final String END_POINT_ID = "notification";
    Map consumerMap = new Hashtable();
    boolean isServerStarted = false;

    NotificationEndPoint() {
    }

    public String bindConsumerToServer(int port, NotificationConsumer con) throws Exception {
        String relativePath2;
        if (this.consumerMap.containsValue(con)) {
            for (String relativePath2 : this.consumerMap.keySet()) {
                if (this.consumerMap.get(relativePath2) != con) continue;
                return relativePath2;
            }
        }
        AbstractServer s = ServerManager.getInstance().getServer(port);
        EndPointManagerImpl.getInstance().putEndPoint(END_POINT_ID, this);
        relativePath2 = this.createRelativePath(con);
        this.consumerMap.put(relativePath2, con);
        String url = "http://" + ServerManager.getHost() + ":" + port + "/" + s.getContext() + "/" + relativePath2;
        return url;
    }

    String createRelativePath(NotificationConsumer con) {
        String base = "notification/" + con.getClass().getName();
        int i = 0;
        while (this.consumerMap.containsKey(String.valueOf(base) + i)) {
            ++i;
        }
        String uri = String.valueOf(base) + i;
        return uri;
    }

    public void unbindConsumerFromServer(NotificationConsumer con) {
        this.consumerMap.values().remove(con);
        if (this.consumerMap.values().isEmpty()) {
            EndPointManagerImpl.getInstance().removeEndPoint(END_POINT_ID);
        }
    }

    public NotificationConsumer getConsumer(String uri) {
        return (NotificationConsumer)this.consumerMap.get(uri);
    }

    public void execute(String urlpath, SOAPEnvelope req, SOAPEnvelope resp) throws SOAPException {
        NotificationConsumer con = this.getConsumer(urlpath);
        if (con == null) {
            RootLogger.getLogger().log(Level.INFO, "Adapter: received notification for unknown consumer. uri=" + urlpath);
            return;
        }
        try {
            SerializedNotification[] rawNotifs = NotifServiceManager.getInstance().getProtocol().extractNotifications(req.getBody());
            int i = 0;
            while (i < rawNotifs.length) {
                Notification notif = new Notification(rawNotifs[i]);
                con.consume(notif);
                ++i;
            }
        }
        catch (Exception e) {
            RootLogger.getLogger().log(Level.SEVERE, "Problem occurred during notification reception", e);
        }
    }
}

