/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.registry;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ToolSelectionStrategy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.QualifiedServiceName;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.ProviderEndPoint;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class DefaultToolSelector
implements ToolSelectionStrategy {
    public Tool selectTool(String serviceName, Collection tools) {
        QualifiedServiceName qname = QualifiedServiceName.getQualifiedServiceName(serviceName);
        Vector<Tool> unvailableTools = new Vector<Tool>();
        Tool t = DefaultToolSelector.findLocalTool(serviceName);
        if (t != null) {
            return t;
        }
        if (tools == null) {
            return null;
        }
        Iterator it = tools.iterator();
        ModelingService ms = null;
        while (it.hasNext() && ms == null) {
            t = (Tool)it.next();
            if (qname.toolName != null && !qname.toolName.equals(t.getName()) || qname.interfaceName != null && !qname.interfaceName.equals(t.getInterface().getName()) || (ms = DescriptionUtil.getServiceDescription(qname.serviceName, t)) == null) continue;
            if (this.ping(t)) {
                tools.removeAll(unvailableTools);
                return t;
            }
            ms = null;
            unvailableTools.add(t);
        }
        return null;
    }

    public static Tool findLocalTool(String serviceName) {
        QualifiedServiceName qname = QualifiedServiceName.getQualifiedServiceName(serviceName);
        if (qname.toolName != null) {
            Tool testTool;
            ModelingService ms;
            AdapterStub adapter = null;
            String relativePath = ProviderEndPoint.getRelativePath(qname.toolName);
            ProviderEndPoint ep = (ProviderEndPoint)EndPointManagerImpl.getInstance().getEndPoint(relativePath);
            if (ep != null) {
                adapter = ep.getAdapterOfProviderTool(relativePath);
            }
            if (adapter != null && (ms = DescriptionUtil.getServiceDescription(serviceName, testTool = adapter.getToolDescription())) != null) {
                return testTool;
            }
        }
        return null;
    }

    private boolean ping(Tool t) {
        String targetUrl = DescriptionUtil.getProperty(t, "URL");
        if (targetUrl == null) {
            return false;
        }
        RootLogger.getLogger().log(Level.INFO, "Pinging URL:" + targetUrl);
        URL url = null;
        try {
            url = new URL(targetUrl);
        }
        catch (MalformedURLException e) {
            return false;
        }
        Socket s = null;
        try {
            s = new Socket(url.getHost(), url.getPort());
        }
        catch (UnknownHostException e1) {
            return false;
        }
        catch (IOException e1) {
            return false;
        }
        try {
            s.close();
        }
        catch (IOException e2) {
            return false;
        }
        return true;
    }
}

