/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.local;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.ProviderEndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.NoAsyncConnectionFoundException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.PollObject;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.ResultNotReadyException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.ThreadPoolQueue;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class LocalInvocationSender
extends DefaultWsInvocationSender {
    private Map pollObjectMap = null;

    public void makeConnection() throws SOAPException {
        RootLogger.getLogger().log(Level.INFO, "Local Call");
        String relativePath = this.getToolUrl().getPath();
        ProviderEndPoint ep = (ProviderEndPoint)EndPointManagerImpl.getInstance().getEndPoint(relativePath);
        RootLogger.getLogger().log(Level.INFO, "Call with Message: " + this.requestMsg.getSOAPBody().toString());
        this.responseMsg = SoapUtil.messageFactory.createMessage();
        ep.execute(relativePath, this.requestMsg.getSOAPPart().getEnvelope(), this.responseMsg.getSOAPPart().getEnvelope());
        RootLogger.getLogger().log(Level.INFO, "Response Message: " + this.responseMsg.getSOAPBody().toString());
    }

    public void makeAsyncConnection() throws SOAPException {
        RootLogger.getLogger().log(Level.INFO, "Asynchronous Local Call");
        if (this.pollObjectMap == null) {
            this.pollObjectMap = new HashMap();
        }
        String relativePath = this.getToolUrl().getPath();
        ProviderEndPoint ep = (ProviderEndPoint)EndPointManagerImpl.getInstance().getEndPoint(relativePath);
        RootLogger.getLogger().log(Level.INFO, "Call with Message: " + this.requestMsg.getSOAPBody().toString());
        PollObject po = new PollObject();
        this.connectionId = String.valueOf(po.hashCode());
        this.pollObjectMap.put(this.connectionId, po);
        LocalInvocationSender.runLocalTask(this.requestMsg, this.responseMsg, po, relativePath, ep, poolQueue);
        connexionId2modelingService.put(this.connectionId, this.ms);
        RootLogger.getLogger().log(Level.INFO, "Response Message: " + this.responseMsg.getSOAPBody().toString());
    }

    public void closeAsyncConnection(String connectionId) throws SOAPException, NoAsyncConnectionFoundException {
        connexionId2modelingService.remove(connectionId);
    }

    public boolean isResultReady(String connectionId) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, NoAsyncConnectionFoundException, ModelingServiceError {
        PollObject po = (PollObject)this.pollObjectMap.get(connectionId);
        return po.isResultReady();
    }

    public Object[] getResult(String connectionId) throws ResultNotReadyException, NoAsyncConnectionFoundException, ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
        PollObject po;
        try {
            po = (PollObject)this.pollObjectMap.get(connectionId);
        }
        catch (ClassCastException e1) {
            throw new NoAsyncConnectionFoundException("asynchronous local call - poll object not found in local pollObjectMap");
        }
        if (po == null) {
            throw new NoAsyncConnectionFoundException("asynchronous local call - poll object not found in local pollObjectMap");
        }
        try {
            this.responseMsg = (SOAPMessage)po.getResult();
            ModelingService ms = (ModelingService)connexionId2modelingService.get(connectionId);
            if (ms == null) {
                throw new Exception("ModelingService not avaible");
            }
            this.readResponseMessage();
            this.closeAsyncConnection(connectionId);
            if (poolQueue.isEmpty()) {
                LocalInvocationSender.closeThreadPoolQueue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Parameter[] outputParams = DescriptionUtil.get_out_inout_Parameters(this.ms).toArray(new Parameter[0]);
        Object[] result = DescriptionUtil.map2Array(outputParams, this.outputs);
        return result;
    }

    private static void runLocalTask(SOAPMessage reqMsg, SOAPMessage resMsg, PollObject po, String relativePath, ProviderEndPoint ep, ThreadPoolQueue pool) {
        LocalTask task = new LocalTask(reqMsg, resMsg, po, relativePath, ep);
        pool.execute(task);
    }

    private static class LocalTask
    implements Runnable {
        private SOAPMessage reqMsg;
        private SOAPMessage resMsg;
        private PollObject po;
        private String relativePath;
        private ProviderEndPoint providerEndPoint;

        public LocalTask(SOAPMessage reqMsg, SOAPMessage resMsg, PollObject po, String relativePath, ProviderEndPoint providerEndPoint) {
            this.reqMsg = reqMsg;
            this.resMsg = resMsg;
            this.po = po;
            this.relativePath = relativePath;
            this.providerEndPoint = providerEndPoint;
        }

        public void run() {
            try {
                this.providerEndPoint.execute(this.relativePath, this.reqMsg.getSOAPPart().getEnvelope(), this.resMsg.getSOAPPart().getEnvelope());
                this.po.registerResult(this.resMsg);
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
    }
}

