/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.axis.message.PrefixedQName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DefaultModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelElementReference;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.Repository;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.Marshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.description.abstract_.EnumerationType;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractFactoryImpl;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMarshaler
implements Marshaler {
    public static final String ERROR_INFO_TAG = "ErrorInfo";
    public static final String ERROR_FULL_TAG = "modelbus:ModelingServiceError";
    public static final String ERROR_TAG = "ModelingServiceError";
    public static final String SCOPE_TAG = "modelbus:Scope";
    public static final String ITEM_TAG = "modelbus:item";
    public static final String REF_TAG = "modelbus:Ref";
    public static final String RESOURCE_TAG = "modelbus:resource";
    public static final String MODEL_SERIALIZER_PROP = "modelbus:modelSerializer";
    public static final String ENCODING = "encoding";
    public static final String ENCODING_MULTIVALUES = "modelbus:multi-values";
    public static final String ENCODING_MODEL_URI = "modelbus:Model-URI";
    public static final String ENCODING_MODEL = "modelbus:Model";
    public static final String MB_STRING = "string";
    public static final String MB_INTEGER = "integer";
    public static final String MB_BOOLEAN = "boolean";
    public static final String MB_DOUBLE = "double";
    public static final String MB_BINARY = "binary";
    ModelSerializerFactory modelSerializerFactory;
    ModelSerializer modelSerializer;
    Repository repositoryClient;

    public void marshal(Parameter p, Object parameterValue, SOAPElement topElem) throws SOAPException {
        if (parameterValue == null) {
            return;
        }
        SOAPElement paramSoapElem = topElem.addChildElement(p.getName());
        if (parameterValue instanceof Object[]) {
            paramSoapElem.setAttribute(ENCODING, ENCODING_MULTIVALUES);
            Object[] values = (Object[])parameterValue;
            int i = 0;
            while (i < values.length) {
                Object singleValue = values[i];
                SOAPElement itemElem = paramSoapElem.addChildElement(ITEM_TAG);
                this.marshallSingleValue(p, singleValue, itemElem);
                ++i;
            }
        } else {
            this.marshallSingleValue(p, parameterValue, paramSoapElem);
        }
    }

    void marshallSingleValue(Parameter p, Object value, SOAPElement elem) throws SOAPException {
        Type t = p.getType();
        if (t instanceof ModelType) {
            if (value instanceof URI) {
                String s = value.toString();
                DefaultMarshaler.setEncodingStyle(p, elem);
                elem.addTextNode(s);
                elem.setAttribute(ENCODING, ENCODING_MODEL_URI);
            } else {
                ModelElementReference[] refs = this.getModelSerializer().getReferences(p, value);
                int i = 0;
                while (i < refs.length) {
                    SOAPElement elem1 = elem.addChildElement(REF_TAG);
                    elem1.setAttribute("uri", refs[i].getUri());
                    elem1.setAttribute("fragment", refs[i].getRef());
                    ++i;
                }
                elem.setAttribute(ENCODING, ENCODING_MODEL);
            }
        } else if (t instanceof EnumerationType) {
            String s = value.toString();
            DefaultMarshaler.setEncodingStyle(p, elem);
            elem.addTextNode(s);
        } else if (t.getName().equalsIgnoreCase(MB_BINARY)) {
            if (!(value instanceof InputStream)) {
                throw new SOAPException("Binary parameters should be of java.io.InputStream type");
            }
            BASE64Encoder encoder = new BASE64Encoder();
            InputStream is = (InputStream)value;
            try {
                byte[] buffer = new byte[is.available()];
                is.read(buffer);
                String s = encoder.encode(buffer);
                DefaultMarshaler.setEncodingStyle(p, elem);
                elem.addTextNode(s);
            }
            catch (IOException e) {
                throw new SOAPException((Throwable)e);
            }
        } else {
            String s = value.toString();
            DefaultMarshaler.setEncodingStyle(p, elem);
            elem.addTextNode(s);
        }
    }

    public static void setEncodingStyle(Parameter p, SOAPElement elem) throws SOAPException {
        Type t = p.getType();
        String typeName = t.getName();
        if (t instanceof PrimitiveType) {
            if (typeName.equalsIgnoreCase(MB_STRING)) {
                elem.setAttribute(ENCODING, "xsd:string");
            } else if (typeName.equalsIgnoreCase(MB_INTEGER)) {
                elem.setAttribute(ENCODING, "xsd:integer");
            } else if (typeName.equalsIgnoreCase(MB_DOUBLE)) {
                elem.setAttribute(ENCODING, "xsd:float");
            } else if (typeName.equalsIgnoreCase(MB_BOOLEAN)) {
                elem.setAttribute(ENCODING, "xsd:boolean");
            } else if (typeName.equalsIgnoreCase(MB_BINARY)) {
                elem.setAttribute(ENCODING, "xsd:base64Binary");
            } else {
                elem.setEncodingStyle(t.getName());
            }
        } else if (t instanceof EnumerationType) {
            elem.setAttribute(ENCODING, "modelbus:Enumeration");
        }
    }

    public Object unmarshal(Parameter p, SOAPElement topElem) throws SOAPException, ModelBusCommunicationException {
        SOAPElement elem = SoapUtil.getChildByLocalName(topElem, p.getName());
        if (elem == null) {
            return null;
        }
        if (ENCODING_MULTIVALUES.equals(elem.getAttribute(ENCODING))) {
            Vector<Object> values = new Vector<Object>();
            Iterator it = elem.getChildElements();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof SOAPElement)) continue;
                SOAPElement subElem = (SOAPElement)o;
                Object v = this.unmarshallSingleValue(p, subElem);
                values.add(v);
            }
            Object[] array = DefaultMarshaler.getArrayForMultiValueParameter(p, values.size());
            return values.toArray(array);
        }
        return this.unmarshallSingleValue(p, elem);
    }

    static Object[] getArrayForMultiValueParameter(Parameter p, int size) {
        Type t = p.getType();
        if (t instanceof PrimitiveType) {
            String typeName = t.getName();
            if (typeName.equalsIgnoreCase(MB_STRING)) {
                return new String[size];
            }
            if (typeName.equalsIgnoreCase(MB_INTEGER)) {
                return new Integer[size];
            }
            if (typeName.equalsIgnoreCase(MB_DOUBLE)) {
                return new Double[size];
            }
            if (typeName.equalsIgnoreCase(MB_BOOLEAN)) {
                return new Boolean[size];
            }
            if (typeName.equalsIgnoreCase(MB_BINARY)) {
                return new ByteArrayInputStream[size];
            }
            return null;
        }
        if (t instanceof EnumerationType) {
            return new String[size];
        }
        if (t instanceof ModelType) {
            return new Collection[size];
        }
        return null;
    }

    Object unmarshallSingleValue(Parameter p, SOAPElement elem) throws ModelBusCommunicationException {
        Type t = p.getType();
        if (t instanceof ModelType) {
            String encoding = elem.getAttribute(ENCODING);
            if (ENCODING_MODEL_URI.equals(encoding)) {
                String uri = elem.getValue();
                RootLogger.getLogger().log(Level.INFO, "Unmarshaling Model URI " + uri);
                if (this.repositoryClient == null) {
                    throw new ModelBusCommunicationException("No repository client");
                }
                List<EObject> model = this.repositoryClient.getModel(uri);
                return model;
            }
            Vector<ModelElementReference> v = new Vector<ModelElementReference>();
            Iterator it = elem.getChildElements();
            while (it.hasNext()) {
                SOAPElement elem1 = (SOAPElement)it.next();
                ModelElementReference r = new ModelElementReference();
                v.add(r);
                r.setUri(elem1.getAttribute("uri"));
                r.setRef(elem1.getAttribute("fragment"));
            }
            ModelElementReference[] refs = v.toArray(new ModelElementReference[v.size()]);
            Object o = this.getModelSerializer().dereference(p, refs);
            return o;
        }
        if (t instanceof EnumerationType) {
            String value = elem.getValue();
            return value;
        }
        String typeName = t.getName();
        String value = elem.getValue();
        if (typeName.equalsIgnoreCase(MB_STRING)) {
            return value;
        }
        if (typeName.equalsIgnoreCase(MB_INTEGER)) {
            return new Integer(Integer.parseInt(value));
        }
        if (typeName.equalsIgnoreCase(MB_DOUBLE)) {
            return new Double(Double.parseDouble(value));
        }
        if (typeName.equalsIgnoreCase(MB_BOOLEAN)) {
            return Boolean.valueOf(value);
        }
        if (typeName.equalsIgnoreCase(MB_BINARY)) {
            byte[] buffer;
            BASE64Decoder decoder = new BASE64Decoder();
            try {
                buffer = decoder.decodeBuffer(value);
            }
            catch (IOException e) {
                throw new ModelTypeMismatchException("decoding error", e);
            }
            return new ByteArrayInputStream(buffer);
        }
        throw new ModelTypeMismatchException("Deserialize error, unknown Type " + t);
    }

    @Override
    public void marshalModelingServiceError(ModelingServiceError err, SOAPFault f) throws SOAPException {
        PrefixedQName n1 = new PrefixedQName("http://www.eclipse.org/mddi/modelbus", ERROR_INFO_TAG, "modelbus");
        f.setFaultCode(ERROR_TAG);
        f.setFaultString(err.getName());
        if (err.getInfo() != null) {
            Detail detail = f.addDetail();
            DetailEntry entry = detail.addDetailEntry((Name)n1);
            if (err.getErrorType() == null) {
                entry.addTextNode(err.getInfo().toString());
            } else {
                this.marshalModelingServiceError(err.getErrorType(), err.getInfo(), (SOAPElement)entry);
            }
        }
    }

    public void marshalModelingServiceError(Error errorType, Object info, SOAPElement element) throws SOAPException {
        AbstractFactoryImpl factory = new AbstractFactoryImpl();
        Parameter parameter = factory.createParameter();
        parameter.setUpper(errorType.getUpper());
        parameter.setName(errorType.getName());
        parameter.setType(errorType.getType());
        Vector<Parameter> params = new Vector<Parameter>();
        params.add(parameter);
        Hashtable<String, Object> values = new Hashtable<String, Object>();
        values.put(errorType.getName(), info);
        this.marshal(params, values, element);
    }

    public Object unmarshalModelingServiceError(Error errorType, SOAPElement element) throws SOAPException, ModelBusCommunicationException {
        AbstractFactoryImpl factory = new AbstractFactoryImpl();
        Parameter parameter = factory.createParameter();
        parameter.setUpper(errorType.getUpper());
        parameter.setName(errorType.getName());
        parameter.setType(errorType.getType());
        Vector<Parameter> params = new Vector<Parameter>();
        params.add(parameter);
        Map<String, Object> valueMap = this.unmarshal(params, element);
        return valueMap.get(errorType.getName());
    }

    public static boolean isModelingServiceError(SOAPFault f) {
        String fcode = f.getFaultCode();
        return fcode.equals(ERROR_FULL_TAG) || fcode.equals(ERROR_TAG);
    }

    public static String getModelingServiceErrorName(SOAPFault f) {
        return f.getFaultString();
    }

    @Override
    public ModelingServiceError unmarshalModelingServiceError(Error errorType, SOAPFault f) throws SOAPException {
        String errName = f.getFaultString();
        PrefixedQName n1 = new PrefixedQName("http://www.eclipse.org/mddi/modelbus", ERROR_INFO_TAG, "modelbus");
        Iterator it = f.getChildElements();
        while (it.hasNext()) {
            Object info;
            SOAPElement el = (SOAPElement)it.next();
            Iterator it2 = el.getChildElements((Name)n1);
            if (!it2.hasNext()) continue;
            SOAPElement infoEl = (SOAPElement)it2.next();
            if (errorType == null) {
                String info2 = infoEl.getValue();
                return new ModelingServiceError(errName, (Object)info2);
            }
            try {
                info = this.unmarshalModelingServiceError(errorType, infoEl);
            }
            catch (Exception e) {
                throw new SOAPException((Throwable)e);
            }
            return new ModelingServiceError(errorType, info);
        }
        return new ModelingServiceError(errName, (Object)null);
    }

    public static void setNamespaces(SOAPBody body) throws SOAPException {
        body.addNamespaceDeclaration("xsd", "http://www.w3.org/1999/XMLSchema");
        body.addNamespaceDeclaration("xsi", "http://www.w3.org/1999/XMLSchema-instance");
        body.addNamespaceDeclaration("modelbus", "http://www.eclipse.org/mddi/modelbus");
    }

    @Override
    public void marshal(List<Parameter> params, Map<String, Object> parameterValues, SOAPElement topElem) throws SOAPException {
        topElem.setAttribute(MODEL_SERIALIZER_PROP, this.getModelSerializerFactory().getName());
        SOAPElement scopeElement = topElem.addChildElement(SCOPE_TAG);
        SerializedXmiDocument[] docs = this.getModelSerializer().serialize(params, parameterValues);
        int i = 0;
        while (i < docs.length) {
            SOAPElement elem1 = scopeElement.addChildElement(RESOURCE_TAG);
            elem1.setAttribute("uri", docs[i].getUri());
            elem1.addTextNode(docs[i].getXmi());
            ++i;
        }
        for (Parameter p : params) {
            Object value = parameterValues.get(p.getName());
            if (value == null) {
                RootLogger.getLogger().log(Level.WARNING, "Missing parameter " + p.getName());
            }
            this.marshal(p, value, topElem);
        }
    }

    @Override
    public Map<String, Object> unmarshal(List<Parameter> params, SOAPElement topElem) throws SOAPException, ModelBusCommunicationException {
        if (params == null) {
            return null;
        }
        SOAPElement scopeElement = SoapUtil.getChildByFullName(topElem, SCOPE_TAG);
        Vector<SerializedXmiDocument> v = new Vector<SerializedXmiDocument>();
        Iterator it = scopeElement.getChildElements();
        while (it.hasNext()) {
            SOAPElement resElem = (SOAPElement)it.next();
            SerializedXmiDocument doc = new SerializedXmiDocument();
            doc.setUri(resElem.getAttribute("uri"));
            doc.setXmi(resElem.getValue());
            v.add(doc);
        }
        SerializedXmiDocument[] docs = v.toArray(new SerializedXmiDocument[v.size()]);
        this.getModelSerializer().deserialize(docs);
        Hashtable<String, Object> valueMap = new Hashtable<String, Object>();
        for (Parameter p : params) {
            Object value = this.unmarshal(p, topElem);
            if (value != null) {
                valueMap.put(p.getName(), value);
                continue;
            }
            RootLogger.getLogger().log(Level.WARNING, "Null parameter " + p.getName());
        }
        return valueMap;
    }

    @Override
    public ModelSerializer getModelSerializer() {
        if (this.modelSerializer == null) {
            this.modelSerializer = this.getModelSerializerFactory().createModelSerializer();
        }
        return this.modelSerializer;
    }

    @Override
    public void setModelSerializerFactory(ModelSerializerFactory f) {
        this.modelSerializerFactory = f;
    }

    public ModelSerializerFactory getModelSerializerFactory() {
        if (this.modelSerializerFactory == null) {
            this.modelSerializerFactory = new DefaultModelSerializerFactory();
        }
        return this.modelSerializerFactory;
    }

    @Override
    public Repository getRepositoryClient() {
        return this.repositoryClient;
    }

    @Override
    public void setRepositoryClient(Repository repositoryClient) {
        this.repositoryClient = repositoryClient;
    }
}

