/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.logging.Level;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultSessionMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.InvalidSession;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericSessionProvider;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class DefaultSessionWsInvocationReceiver
extends DefaultWsInvocationReceiver {
    boolean isModelingSeriviceCall = false;

    public DefaultSessionWsInvocationReceiver(AdapterStub adapter) {
        super(adapter);
        this.marshaler = new DefaultSessionMarshaler();
    }

    public void performService() throws SessionNeeded, ModelingServiceError, InvalidSession {
        if (this.isModelingSeriviceCall) {
            GenericSessionProvider si = this.adapter.getToolStub().getSessionProvider();
            String serviceName = this.ms.getName();
            Parameter[] inputParams = DescriptionUtil.get_in_inout_Parameters(this.ms).toArray(new Parameter[0]);
            Parameter[] outputParams = DescriptionUtil.get_out_inout_Parameters(this.ms).toArray(new Parameter[0]);
            Object[] inputArray = DescriptionUtil.map2Array(inputParams, this.inputs);
            Object[] outputArray = si.executeSession(serviceName, inputArray, ((DefaultSessionMarshaler)this.marshaler).getSessionId());
            this.outputs = DescriptionUtil.array2Map(outputParams, outputArray);
        }
    }

    public void createResponse() throws Exception {
        if (this.isModelingSeriviceCall) {
            super.createResponse();
        }
    }

    public void newSession() throws Exception {
        GenericSessionProvider si = this.adapter.getToolStub().getSessionProvider();
        String sessionId = si.newSession();
        RootLogger.getLogger().log(Level.INFO, "Sender Session ID" + sessionId);
        SOAPBody responsebody = this.resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPElement resTopElem = responsebody.addChildElement("newSessionResponse", "modelbus");
        ((DefaultSessionMarshaler)this.getMarshaler()).setSessionId(sessionId);
        this.getMarshaler().marshal(null, null, resTopElem);
        RootLogger.getLogger().log(Level.INFO, "Res:" + responsebody);
    }

    void endSession() throws Exception {
        SOAPBody requestbody = this.reqMsg.getBody();
        SOAPElement reqTopElem = SoapUtil.getFirstChild((SOAPElement)requestbody);
        this.marshaler.unmarshal(null, reqTopElem);
        String sessionId = ((DefaultSessionMarshaler)this.marshaler).getSessionId();
        GenericSessionProvider si = this.adapter.getToolStub().getSessionProvider();
        si.endSession(sessionId);
        SOAPBody responsebody = this.resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        responsebody.addChildElement("endSessionResponse", "modelbus");
    }

    public void readRequest() throws Exception {
        SOAPBody requestbody = this.reqMsg.getBody();
        SOAPElement reqTopElem = SoapUtil.getFirstChild((SOAPElement)requestbody);
        if (reqTopElem == null) {
            RootLogger.getLogger().log(Level.SEVERE, "SERVER: receive empty request");
            RootLogger.getLogger().log(Level.INFO, this.reqMsg.toString());
            throw new SOAPException("Empty SOAP request");
        }
        String serviceName = reqTopElem.getLocalName();
        if (serviceName.equals("newSession")) {
            this.newSession();
            return;
        }
        if (serviceName.equals("endSession")) {
            this.endSession();
            return;
        }
        this.isModelingSeriviceCall = true;
        super.readRequest();
    }
}

