/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultSessionMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;

public class DefaultSessionWsInvocationSender
extends DefaultWsInvocationSender
implements SessionProviderProxy {
    public static final String NEW_SESSION_TAG = "newSession";
    public static final String END_SESSION_TAG = "endSession";
    private SessionManager sessionManager;

    public DefaultSessionWsInvocationSender() {
        this.setMarshaler(new DefaultSessionMarshaler());
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public String newSession() throws ModelBusCommunicationException {
        try {
            this.createNewSessionRequest();
            this.makeConnection();
            this.readNewSessionResponse();
        }
        catch (Exception e) {
            RootLogger.getLogger().log(Level.SEVERE, "Can't make newSession", e);
            throw new ModelBusCommunicationException("Can't make newSession", e);
        }
        String sessionId = ((DefaultSessionMarshaler)this.getMarshaler()).getSessionId();
        this.sessionManager.putProviderProxy(sessionId, this);
        return sessionId;
    }

    public void endSession(String sessionId) throws ModelBusCommunicationException {
        try {
            this.createEndSessionRequest();
            this.makeConnection();
            this.readEndSessionResponse();
        }
        catch (Exception e) {
            RootLogger.getLogger().log(Level.SEVERE, "Can't make endSession", e);
            throw new ModelBusCommunicationException("Can't make endSession", e);
        }
        this.sessionManager.removeSession(sessionId);
    }

    public String[] getOpenSessions() {
        return this.sessionManager.getOpenSessions(String.valueOf(this.getToolDescription().getName()) + "." + this.getToolDescription().getInterface().getName() + ".*");
    }

    public Map invoke(ModelingService ms, Map inputs, String sessionId) throws ModelBusCommunicationException {
        ((DefaultSessionMarshaler)this.getMarshaler()).setSessionId(sessionId);
        try {
            return this.invoke(ms, inputs);
        }
        catch (Exception e) {
            throw new ModelBusCommunicationException("Can't invoke serivce at:" + this.getToolUrl(), e);
        }
    }

    public void createNewSessionRequest() throws SOAPException {
        this.requestMsg = SoapUtil.messageFactory.createMessage();
        SOAPBody requestbody = this.requestMsg.getSOAPBody();
        DefaultMarshaler.setNamespaces(requestbody);
        requestbody.addChildElement(NEW_SESSION_TAG, "modelbus");
    }

    public void readNewSessionResponse() throws Exception {
        SOAPBody responsebody = this.responseMsg.getSOAPBody();
        if (responsebody.hasFault()) {
            this.readResponseMessage();
        } else {
            SOAPElement resTopElem = SoapUtil.getFirstChild((SOAPElement)responsebody);
            if (resTopElem == null) {
                RootLogger.getLogger().log(Level.SEVERE, "Empty SOAP response");
                RootLogger.getLogger().log(Level.INFO, responsebody.toString());
                throw new ModelBusCommunicationException("Empty SOAP response");
            }
            this.getMarshaler().unmarshal(null, resTopElem);
        }
    }

    public void createEndSessionRequest() throws Exception {
        this.requestMsg = SoapUtil.messageFactory.createMessage();
        SOAPBody requestbody = this.requestMsg.getSOAPBody();
        DefaultMarshaler.setNamespaces(requestbody);
        SOAPElement reqTopElem = requestbody.addChildElement(END_SESSION_TAG, "modelbus");
        this.getMarshaler().marshal(null, null, reqTopElem);
    }

    public void readEndSessionResponse() throws ModelBusCommunicationException, SOAPException {
        SOAPBody responsebody = this.responseMsg.getSOAPBody();
        if (responsebody.hasFault()) {
            this.readResponseMessage();
        }
    }

    public String invokeAsync(ModelingService ms, Map inputs, String sessionID) throws ModelBusCommunicationException {
        ((DefaultSessionMarshaler)this.getMarshaler()).setSessionId(sessionID);
        try {
            return super.invokeAsync(ms, inputs);
        }
        catch (Exception e) {
            throw new ModelBusCommunicationException("Can't invoke serivce at:" + this.getToolUrl(), e);
        }
    }

    public static void main(String[] args) {
        Object p = null;
        DefaultSessionWsInvocationSender sender = new DefaultSessionWsInvocationSender();
        try {
            sender.createNewSessionRequest();
            System.out.println("New Req:" + sender.requestMsg.getSOAPBody().toString());
            ((DefaultSessionMarshaler)sender.getMarshaler()).setSessionId("AAAA");
            sender.createEndSessionRequest();
            System.out.println("End Req:" + sender.requestMsg.getSOAPBody().toString());
            String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"\n                   xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n                   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n <soapenv:Body>\n <modelbus:newSessionResponse xmlns:modelbus=\"http://www.modelware-ist.org/modelbus\"><modelbus:sessionId>BBBBB</modelbus:sessionId></modelbus:newSessionResponse>\n </soapenv:Body>\n</soapenv:Envelope>";
            MessageFactory mf = MessageFactory.newInstance();
            sender.responseMsg = mf.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(xmlString.getBytes()));
            sender.readNewSessionResponse();
            System.out.println("newSession Read sessionId:" + ((DefaultSessionMarshaler)sender.getMarshaler()).getSessionId());
            xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"\n                   xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n                   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n <soapenv:Body>\n <modelbus:endSessionResponse xmlns:modelbus=\"http://www.modelware-ist.org/modelbus\"><modelbus:sessionId>CCCCCC</modelbus:sessionId></modelbus:endSessionResponse>\n </soapenv:Body>\n</soapenv:Envelope>";
            mf = MessageFactory.newInstance();
            sender.responseMsg = mf.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(xmlString.getBytes()));
            sender.readNewSessionResponse();
            System.out.println("endSession Read sessionId:" + ((DefaultSessionMarshaler)sender.getMarshaler()).getSessionId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

