/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.axis.SimpleModelBusServer;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;

public class ServerManager {
    public static final String DEFAULT_CONTEXT = "modelbus";
    public static int DEFAULT_MB_PORT = 8081;
    static ServerManager instance = new ServerManager();
    Set servers = new HashSet();

    public static ServerManager getInstance() {
        return instance;
    }

    ServerManager() {
    }

    public void putServer(AbstractServer s) {
        if (this.servers.contains(s)) {
            return;
        }
        this.servers.add(s);
        s.setEndPointManager(EndPointManagerImpl.getInstance());
    }

    public AbstractServer getServer(int port) throws Exception {
        for (AbstractServer test : this.servers) {
            if (test.getPort() != port) continue;
            return test;
        }
        SimpleModelBusServer s = null;
        s = new SimpleModelBusServer(port);
        this.putServer(s);
        return s;
    }

    public static String getHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress().toString();
        }
        catch (UnknownHostException e) {
            RootLogger.getLogger().log(Level.SEVERE, "The host is not connected to internet");
            return "localhost";
        }
    }

    public static int getModelBusPort(AdapterStub adapter) {
        String portString = adapter.getProperties().getProperty("modelbus_port");
        if (portString != null) {
            try {
                int port = Integer.parseInt(portString);
                return port;
            }
            catch (NumberFormatException e) {
                RootLogger.getLogger().log(Level.SEVERE, "Adapter. bad PROP_MODELBUS_PORT (" + portString + "). used default (" + DEFAULT_MB_PORT + ")");
            }
        }
        return DEFAULT_MB_PORT;
    }

    public void shutdown() {
        for (SimpleModelBusServer test : this.servers) {
            test.stop();
        }
        this.servers.clear();
        RootLogger.getLogger().log(Level.INFO, "The server is shutdown.");
    }
}

