/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.axis;

import java.net.ServerSocket;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.SimpleAxisServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.SoapUtil;

public class SimpleModelBusServer
extends SimpleAxisServer
implements AbstractServer {
    EngineConfigurationImpl config = new EngineConfigurationImpl();
    EndPointManager endPointManager;
    AxisServer internalAxisServer;
    int port;
    ServerSocket socket = null;
    String context = "modelbus";

    public SimpleModelBusServer(int port) throws Exception {
        this.port = port;
        this.setMyConfig(this.config);
        this.internalAxisServer = new MBAxisServer(this.config);
        this.startSimpleModelBusServer();
    }

    private void startSimpleModelBusServer() {
        int count = 0;
        boolean isStarted = false;
        while (count < 10 && !isStarted) {
            try {
                this.socket = new ServerSocket(this.port);
                this.setServerSocket(this.socket);
                this.start();
                RootLogger.getLogger().log(Level.INFO, "Stared on " + this.port);
                isStarted = true;
            }
            catch (Exception e) {
                RootLogger.getLogger().log(Level.INFO, "port not free " + this.port + " " + e);
                ++count;
                ++this.port;
            }
        }
    }

    public void setEndPointManager(EndPointManager endPointManager) {
        this.endPointManager = endPointManager;
    }

    public synchronized AxisServer getAxisServer() {
        return this.internalAxisServer;
    }

    public int getPort() {
        return this.port;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    class EngineConfigurationImpl
    implements EngineConfiguration {
        Hashtable globalOptions = new Hashtable();
        List deployedServices = new Vector();

        EngineConfigurationImpl() {
        }

        public void configureEngine(AxisEngine engine) throws ConfigurationException {
            RootLogger.getLogger().log(Level.INFO, "configureEngine()");
        }

        public void writeEngineConfig(AxisEngine engine) throws ConfigurationException {
            RootLogger.getLogger().log(Level.INFO, "writeEngineConfig()");
        }

        public Handler getHandler(QName qname) throws ConfigurationException {
            RootLogger.getLogger().log(Level.INFO, "getHandler()");
            return null;
        }

        public SOAPService getService(QName qname) throws ConfigurationException {
            RootLogger.getLogger().log(Level.INFO, "getService()");
            return null;
        }

        public SOAPService getServiceByNamespaceURI(String namespace) throws ConfigurationException {
            return null;
        }

        public Handler getTransport(QName qname) throws ConfigurationException {
            RootLogger.getLogger().log(Level.INFO, "getTransport()");
            return null;
        }

        public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
            RootLogger.getLogger().log(Level.INFO, "getTypeMappingRegistry()");
            return null;
        }

        public Handler getGlobalRequest() throws ConfigurationException {
            RootLogger.getLogger().log(Level.INFO, "getGlobalRequest()");
            return null;
        }

        public Handler getGlobalResponse() throws ConfigurationException {
            RootLogger.getLogger().log(Level.INFO, "getGlobalResponse()");
            return null;
        }

        public Hashtable getGlobalOptions() throws ConfigurationException {
            RootLogger.getLogger().log(Level.INFO, "getGlobalOptions()");
            return this.globalOptions;
        }

        public Iterator getDeployedServices() throws ConfigurationException {
            RootLogger.getLogger().log(Level.INFO, "getDeployedServices()");
            return this.deployedServices.iterator();
        }

        public List getRoles() {
            RootLogger.getLogger().log(Level.INFO, "getRoles()");
            return new Vector();
        }
    }

    class MBAxisServer
    extends AxisServer {
        private static final long serialVersionUID = 2422416854888267679L;

        MBAxisServer(EngineConfiguration config) {
            super(config);
        }

        public void invoke(MessageContext msgContext) throws AxisFault {
            String urlPath = (String)msgContext.getProperty("path");
            RootLogger.getLogger().log(Level.INFO, "Receiving a request : URL = " + urlPath);
            String relativePath = "";
            if (urlPath.startsWith(String.valueOf(SimpleModelBusServer.this.context) + "/")) {
                relativePath = urlPath.replaceFirst(String.valueOf(SimpleModelBusServer.this.context) + "/", "");
            }
            if (SimpleModelBusServer.this.endPointManager == null) {
                RootLogger.getLogger().log(Level.SEVERE, "No EndPointManager");
                return;
            }
            try {
                Message req = msgContext.getRequestMessage();
                Message resp = (Message)SoapUtil.messageFactory.createMessage();
                SimpleModelBusServer.this.endPointManager.execute(relativePath, (SOAPEnvelope)req.getSOAPEnvelope(), (SOAPEnvelope)resp.getSOAPEnvelope());
                msgContext.setResponseMessage(resp);
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
    }
}

