/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.ETValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.EValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MPValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MSIValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MSValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MetaSValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.PValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.TValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.ToolValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MPException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TypeFormatException;

public class Validation {
    public static void globalValidation(ModelBusPackaging mp) throws MPException, MSIException, TException, EException, ETException, NameFormatException, MetaSException, MSException, PException, ToolException {
        EList mPContents = mp.getContent();
        int toolFound = 0;
        int i = 0;
        while (i < mPContents.size()) {
            Object mPContent = mPContents.get(i);
            if (mPContent instanceof Tool) {
                ++toolFound;
                ToolValidation.validateTool(mp);
            }
            ++i;
        }
        if (toolFound != 1) {
            throw new MPException("ModelBusPackage :" + mp.getName() + " has more or less than one Tool, this ModelBusPackage" + " must have exactly one Tool");
        }
        Validation.globalValidationRec(mp);
        if (MPValidation.getToolsFound() != 1) {
            throw new MPException("ModelBusPackage :" + mp.getName() + " has Tool(s) in its sons, only the first ModelBusPackage " + "must have exactly one Tool");
        }
        if (!MPValidation.isMsiFound()) {
            throw new MPException("ModelBusPackage :" + mp.getName() + " has no ModelingServiceInterface, it must have at least one");
        }
    }

    public static void globalValidationRec(ModelBusPackaging mp) throws MPException, MSIException, TException, EException, ETException, NameFormatException, MetaSException, MSException, PException, ToolException {
        MPValidation.validateMP(mp);
        MSIValidation.validateMSI(mp);
        EValidation.validationE(mp);
        ETValidation.validationET(mp);
        MetaSValidation.validateMetaS(mp);
        MSValidation.validationMS(mp);
        PValidation.validationParameter(mp);
        TValidation.validationT(mp);
        MSValidation.validationMS(mp);
        PValidation.validationParameter(mp);
    }

    /*
     * Unable to fully structure code
     */
    public static void validateName(String name, String className) throws NameFormatException {
        javaReservedKeywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
        if (name == null) {
            throw new NameFormatException("A " + className + " has its name attribute missing");
        }
        if (name.equals("")) {
            throw new NameFormatException("A " + className + " has its name attribute empty");
        }
        try {
            intName = Integer.parseInt(name.substring(0, 1));
            throw new NameFormatException(String.valueOf(className) + " name: " + name + " begins with number " + intName);
        }
        catch (NumberFormatException e) {
            i = 0;
            ** while (i < javaReservedKeywords.length)
        }
lbl-1000:
        // 1 sources

        {
            if (javaReservedKeywords[i].equals(name)) {
                throw new NameFormatException("A " + className + " has its name which is a reserved keyword of Java");
            }
            ++i;
            continue;
        }
lbl16:
        // 1 sources

        i = 0;
        while (i < name.length()) {
            if (!(name.charAt(i) == '_' || name.charAt(i) == '$' || name.charAt(i) >= '0' && name.charAt(i) <= '9' || name.charAt(i) >= 'A' && name.charAt(i) <= 'Z' || name.charAt(i) >= 'a' && name.charAt(i) <= 'z')) {
                throw new NameFormatException("A " + className + " has its name which is a word contening letters a-z A-Z, numbers 0-9, underscore or dollarsign");
            }
            ++i;
        }
    }

    public static void validateType(Type type, String className) throws TypeFormatException {
        if (type == null) {
            throw new TypeFormatException("A  " + className + " has  its type attribute missing");
        }
        if (type.getName().equals("")) {
            throw new TypeFormatException("A  " + className + "  has  its type attribute missing");
        }
    }
}

