/**
 * <copyright>
 * </copyright>
 *
 * $Id: DescriptionModelWizard.java,v 1.2 2006/02/06 16:19:28 xblanc Exp $
 */
package org.eclipse.mddi.modelbus.description.presentation;


import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.common.util.URI;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.xmi.XMLResource;

import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

import org.eclipse.core.runtime.IProgressMonitor;

import org.eclipse.jface.dialogs.MessageDialog;

import org.eclipse.jface.viewers.IStructuredSelection;

import org.eclipse.jface.wizard.Wizard;

import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import org.eclipse.ui.actions.WorkspaceModifyOperation;


import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

import org.eclipse.mddi.modelbus.description.DescriptionFactory;
import org.eclipse.mddi.modelbus.description.DescriptionPackage;


import modelbus.description.presentation.ModelbusEditorPlugin;


import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;


/**
 * This is a simple wizard for creating a new model file.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DescriptionModelWizard extends Wizard implements INewWizard {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.  All rights reserved.This software is published under the terms of the ModelBus Software License in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. A copy of ModelBus Software License is provided with this distribution in doc/LICENSE.txt file.";

    /**
     * This caches an instance of the model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DescriptionPackage descriptionPackage = DescriptionPackage.eINSTANCE;

    /**
     * This caches an instance of the model factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DescriptionFactory descriptionFactory = descriptionPackage.getDescriptionFactory();

    /**
     * This is the file creation page.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DescriptionModelWizardNewFileCreationPage newFileCreationPage;

    /**
     * This is the file creation page.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DescriptionModelWizardInitialObjectCreationPage initialObjectCreationPage;

    /**
     * Remember the selection during initialization for populating the default container.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IStructuredSelection selection;

    /**
     * Remember the workbench during initialization.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IWorkbench workbench;

    /**
     * This just records the information.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        setWindowTitle(ModelbusEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(ModelbusEditorPlugin.INSTANCE.getImage("full/wizban/NewDescription")));
    }

    /**
     * Create a new model.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EObject createInitialModel() {
        EClass eClass = (EClass)descriptionPackage.getEClassifier(initialObjectCreationPage.getInitialObjectName());
        EObject rootObject = descriptionFactory.create(eClass);
        return rootObject;
    }

    /**
     * Do the work after everything is specified.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean performFinish() {
        try {
            // Remember the file.
            //
            final IFile modelFile = getModelFile();

            // Do the work within an operation.
            //
            WorkspaceModifyOperation operation =
                new WorkspaceModifyOperation() {
                    protected void execute(IProgressMonitor progressMonitor) {
                        try {
                            // Create a resource set
                            //
                            ResourceSet resourceSet = new ResourceSetImpl();

                            // Get the URI of the model file.
                            //
                            URI fileURI = URI.createPlatformResourceURI(modelFile.getFullPath().toString());

                            // Create a resource for this file.
                            //
                            Resource resource = resourceSet.createResource(fileURI);

                            // Add the initial model object to the contents.
                            //
                            EObject rootObject = createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add(rootObject);
                            }

                            // Save the contents of the resource to the file system.
                            //
                            Map options = new HashMap();
                            options.put(XMLResource.OPTION_ENCODING, initialObjectCreationPage.getEncoding());
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            ModelbusEditorPlugin.INSTANCE.log(exception);
                        }
                        finally {
                            progressMonitor.done();
                        }
                    }
                };

            getContainer().run(false, false, operation);

            // Select the new file resource in the current view.
            //
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                final ISelection targetSelection = new StructuredSelection(modelFile);
                getShell().getDisplay().asyncExec
                    (new Runnable() {
                         public void run() {
                             ((ISetSelectionTarget)activePart).selectReveal(targetSelection);
                         }
                     });
            }

            // Open an editor on the new file.
            //
            try {
                page.openEditor
                    (new FileEditorInput(modelFile),
                     workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError(workbenchWindow.getShell(), ModelbusEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), exception.getMessage());
                return false;
            }

            return true;
        }
        catch (Exception exception) {
            ModelbusEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    /**
     * This is the one page of the wizard.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */

    public void addPages() {
        // Create a page, set the title, and the initial model file name.
        //
        newFileCreationPage = new DescriptionModelWizardNewFileCreationPage("Whatever", selection);
        newFileCreationPage.setTitle(ModelbusEditorPlugin.INSTANCE.getString("_UI_DescriptionModelWizard_label"));
        newFileCreationPage.setDescription(ModelbusEditorPlugin.INSTANCE.getString("_UI_DescriptionModelWizard_description"));
        newFileCreationPage.setFileName(ModelbusEditorPlugin.INSTANCE.getString("_UI_DescriptionEditorFilenameDefaultBase") + "." + ModelbusEditorPlugin.INSTANCE.getString("_UI_DescriptionEditorFilenameExtension"));
        addPage(newFileCreationPage);

        // Try and get the resource selection to determine a current directory for the file dialog.
        //
        if (selection != null && !selection.isEmpty()) {
            // Get the resource...
            //
            Object selectedElement = selection.iterator().next();
            if (selectedElement instanceof IResource) {
                // Get the resource parent, if its a file.
                //
                IResource selectedResource = (IResource)selectedElement;
                if (selectedResource.getType() == IResource.FILE) {
                    selectedResource = selectedResource.getParent();
                }

                // This gives us a directory...
                //
                if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                    // Set this for the container.
                    //
                    String currentDirectory = selectedResource.getLocation().toOSString();
                    newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());

                    // Make up a unique new name here.
                    //
                    String defaultModelBaseFilename = ModelbusEditorPlugin.INSTANCE.getString("_UI_DescriptionEditorFilenameDefaultBase");
                    String defaultModelFilenameExtension = ModelbusEditorPlugin.INSTANCE.getString("_UI_DescriptionEditorFilenameExtension");
                    String modelFilename = defaultModelBaseFilename + "." + defaultModelFilenameExtension;
                    for (int i = 1; ((IContainer)selectedResource).findMember(modelFilename) != null; ++i) {
                        modelFilename = defaultModelBaseFilename + i + "." + defaultModelFilenameExtension;
                    }
                    newFileCreationPage.setFileName(modelFilename);
                }
            }
        }
        initialObjectCreationPage = new DescriptionModelWizardInitialObjectCreationPage("Whatever2");
        initialObjectCreationPage.setTitle(ModelbusEditorPlugin.INSTANCE.getString("_UI_DescriptionModelWizard_label"));
        initialObjectCreationPage.setDescription(ModelbusEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        addPage(initialObjectCreationPage);
    }

    /**
     * Get the file from the page.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public IFile getModelFile() {
        return newFileCreationPage.getModelFile();
    }

}
