/*
 * $RCSfile: DescriptionModelWizardInitialObjectCreationPage.java,v $
 * $Date: 2006/02/06 16:19:28 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * DescriptionModelWizardInitialObjectCreationPage.java Add description 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1 $ $Date: 2006/02/06 16:19:28 $
 */
package org.eclipse.mddi.modelbus.description.presentation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;

import modelbus.description.presentation.ModelbusEditorPlugin;
import modelbus.description.provider.ModelbusEditPlugin;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mddi.modelbus.description.DescriptionPackage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
 * DescriptionModelWizardInitialObjectCreationPage
 * 
 */

public class DescriptionModelWizardInitialObjectCreationPage extends WizardPage {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected String initialObjectName;
    protected DescriptionPackage descriptionPackage = DescriptionPackage.eINSTANCE;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Combo initialObjectField;

    /**
     * @generated
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     */
    protected String encoding;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Combo encodingField;

    /**
     * Pass in the selection.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DescriptionModelWizardInitialObjectCreationPage(String pageId) {
        super(pageId);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        {
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout(layout);

            GridData data = new GridData();
            data.verticalAlignment = GridData.FILL;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = GridData.FILL;
            composite.setLayoutData(data);
        }

        Label containerLabel = new Label(composite, SWT.LEFT);
        {
            containerLabel.setText(ModelbusEditorPlugin.INSTANCE.getString("_UI_ModelObject"));

            GridData data = new GridData();
            data.horizontalAlignment = GridData.FILL;
            containerLabel.setLayoutData(data);
        }

        initialObjectField = new Combo(composite, SWT.BORDER);
        {
            GridData data = new GridData();
            data.horizontalAlignment = GridData.FILL;
            data.grabExcessHorizontalSpace = true;
            initialObjectField.setLayoutData(data);
        }

        List objectNames = new ArrayList();
        for (Iterator classifier = descriptionPackage.getEClassifiers().iterator(); classifier.hasNext(); ) {
            EClassifier eClassifier = (EClassifier)classifier.next();
            if (eClassifier instanceof EClass) {
                EClass eClass = (EClass)eClassifier;
                if (!eClass.isAbstract()) {
                    objectNames.add(getLabel(eClass));
                }
            }
        }

        Collections.sort(objectNames, java.text.Collator.getInstance());
        for (Iterator i = objectNames.iterator(); i.hasNext(); ) {
            String objectName = (String)i.next();
            initialObjectField.add(objectName);
        }

        initialObjectField.addSelectionListener
            (new SelectionAdapter() {
                 public void widgetSelected(SelectionEvent e) {
                     setPageComplete(isPageComplete());
                 }
             });

        Label encodingLabel = new Label(composite, SWT.LEFT);
        {
            encodingLabel.setText(ModelbusEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));

            GridData data = new GridData();
            data.horizontalAlignment = GridData.FILL;
            encodingLabel.setLayoutData(data);
        }
        encodingField = new Combo(composite, SWT.BORDER);
        {
            GridData data = new GridData();
            data.horizontalAlignment = GridData.FILL;
            data.grabExcessHorizontalSpace = true;
            encodingField.setLayoutData(data);
        }

        for (StringTokenizer stringTokenizer = new StringTokenizer(ModelbusEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices")); stringTokenizer.hasMoreTokens(); ) {
            encodingField.add(stringTokenizer.nextToken());
        }
        encodingField.select(0);

        setControl(composite);
    }

    /**
     * The framework calls this to see if the file is correct.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            return initialObjectField.getSelectionIndex() != -1;
        }
        else {
            return false;
        }
    }

    /**
     * Store the dialog field settings upon completion.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean performFinish() {
        initialObjectName = getInitialObjectName();
        encoding = getEncoding();
        return true;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getInitialObjectName() {
        if (initialObjectName != null) {
            return initialObjectName;
        }
        else {
            String label = initialObjectField.getText();
            for (Iterator classifier = descriptionPackage.getEClassifiers().iterator(); classifier.hasNext(); ) {
                EClassifier eClassifier = (EClassifier)classifier.next();
                if (eClassifier instanceof EClass) {
                    EClass eClass = (EClass)eClassifier;
                    if (!eClass.isAbstract() && getLabel(eClass).equals(label)) {
                        return eClass.getName();
                    }
                }
            }
            return label;
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getEncoding() {
        return
            encoding == null ?
                encodingField.getText() :
                encoding;
    }
    /**
     * Returns the label of the specified element.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected String getLabel(EClass eClass) {
        String name = eClass.getName();
        try {
            return ModelbusEditPlugin.INSTANCE.getString("_UI_" + name + "_type");
        }
        catch(MissingResourceException mre) {
        }
        return name;
    }
}
