/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit;

import java.util.Hashtable;

import org.eclipse.mddi.modelbus.toolkit.adapter.generator.Generator;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;


/**
 * 
 * Console front end of the generator
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner, Saoussen Kraiem, Rmy-Christophe Schermesser, Marc Schwitzgubel 
 *
 */
public class ToolKit {

	/**
	 * String HELP_OPTION : String for the help option
	 */
	protected static final String HELP_OPTION = "-help";
	
	/**
	 * String OUTPUT_DIRECTORY_OPTION : String for the output directory option
	 */
	protected static final String OUTPUT_DIRECTORY_OPTION = "-directory";
	
	/**
	 * String OUTPUT_PACKAGE_OPTION : String for the output package option
	 */
	protected static final String OUTPUT_PACKAGE_OPTION = "-package";
	
	/**
	 * 
	 * Main method for the console mode of the ToolKit
	 * 
	 * @param args The parameter of this program
	 * 
	 */
	public static void main(String[] args) {
		try {
			Hashtable arguments = new Hashtable();

			for(int i = 1; i < args.length; i++) {
				if(args[i].compareTo(OUTPUT_DIRECTORY_OPTION) == 0 ||
				   args[i].compareTo(OUTPUT_PACKAGE_OPTION) == 0) {
					arguments.put(args[i], args[i + 1]);
					i++;
				} else {
					throw new Exception();
				}
			}

			String fileName = args[0];
			String outputDirectory = (String)arguments.get(OUTPUT_DIRECTORY_OPTION);
			String outputPackage = (String)arguments.get(OUTPUT_PACKAGE_OPTION);
			
			if(outputDirectory == null) {
				outputDirectory = ".";
			}
			if(outputPackage == null) {
				outputPackage = "";
			}
			
			try {
				DescriptionModelLoader modelLoader = new DescriptionModelLoader(fileName);
				Validation.globalValidation(modelLoader.getModelBusPackaging());
				Generator.generateAdapter(modelLoader, outputDirectory, outputPackage);
			} catch(Exception e) {
				e.printStackTrace();
				System.out.println(e.getMessage());	
			}
		} catch (Exception e) {		
			printHelp();
		}
	}
	
    /**
     *  Print the help message
     */
    protected static void printHelp() {
        System.out.println("Usage: java -jar ToolKit.jar tool_description_file [-options]\n" +
                           "\n" +
                           "where options include:\n" +
                           "\t" + OUTPUT_DIRECTORY_OPTION + "\tto specify the output directory for the generated files\n" +
                           "\t" + OUTPUT_PACKAGE_OPTION + "\tto specify the package for the generated files\n" +
                           "\t" + HELP_OPTION + "\tto print this message\n" +
                           "\n" +
                           "For further help please see the user manual\n");
    }
}
