/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import java.util.Vector;

/**
 * 
 * Class for a output holder
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner, Saoussen Kraiem, Rmy-Christophe Schermesser, Marc Schwitzgubel
 * 
 */
public class OutputHolderClass {
	
	private String name;
	private Vector parametres;

	/**
	 * 
	 * Constructor 
	 * 
	 * @param name
	 * @param parametres
	 */
	public OutputHolderClass(String name, Vector parametres) {
		super();
		this.name = name;
		this.parametres = parametres;
	}
	
	/**
	 * 
	 * Get the name of this output holder
	 * 
	 * @return String
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * Set the name
	 * 
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * 
	 * Get the paramter
	 * 
	 * @return Vector
	 */
	public Vector getParametres() {
		return parametres;
	}
	
	/**
	 * Set the parameters
	 * 
	 * @param parametres
	 */
	public void setParametres(Vector parametres) {
		this.parametres = parametres;
	}
}