
package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;

/**
 * Class for the equivalence of the types
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner, Saoussen Kraiem, Rmy-Christophe Schermesser, Marc Schwitzgubel
 *
 */
public class TypeConversion {
	
	/**
	 * String STRING_JAVA
	 */
	public static final String STRING_JAVA = "java.lang.String";
	
	/**
	 * String BOOLEAN_JAVA
	 */
	public static final String BOOLEAN_JAVA="java.lang.Boolean";
	
	/**
	 * String INTEGER_JAVA
	 */
	public static final String INTEGER_JAVA="java.lang.Integer";
	
	/**
	 * String DOUBLE_JAVA
	 */
	public static final String DOUBLE_JAVA="java.lang.Double";
	
	/**
	 * String COLLECTION_JAVA
	 */
	public static final String COLLECTION_JAVA ="java.util.Collection";
	
	/**
	 * String MULTI_JAVA
	 */
	public static final String MULTI_JAVA="[]";
	
	/**
	 * String STRING_STRING
	 */
	public static final String STRING_STRING="string";
	
	/**
	 * String BOOLEAN_STRING
	 */
	public static final String BOOLEAN_STRING="boolean";
	
	/**
	 * String INTEGER_STRING
	 */
	public static final String INTEGER_STRING="integer";
	
	/**
	 * String DOUBLE_STRING
	 */
	public static final String DOUBLE_STRING="double";
	
	/**
	 * Convert the primitive types
	 * 
	 * @param string The string to convert
	 * @return String The correct type
	 */
	public static String convertSinglePrimitive(String string){
		if (string.equals(STRING_STRING)) return STRING_JAVA;
		if (string.equals(BOOLEAN_STRING)) return BOOLEAN_JAVA;
		if (string.equals(INTEGER_STRING)) return INTEGER_JAVA;
		if (string.equals(DOUBLE_STRING)) return DOUBLE_JAVA;
		return "// no type found";
		
	}
	
	/**
	 * Convert the primtive types for an array
	 * 
	 * @param string The string to convert
	 * @return String The correct type
	 */
	public static String convertMultiPrimitive(String string){
		if (string.equals(STRING_STRING)) return STRING_JAVA+MULTI_JAVA;
		if (string.equals(BOOLEAN_STRING)) return BOOLEAN_JAVA+MULTI_JAVA;
		if (string.equals(INTEGER_STRING)) return INTEGER_JAVA+MULTI_JAVA;
		if (string.equals(DOUBLE_STRING)) return DOUBLE_JAVA+MULTI_JAVA;
		return "// no type found";
		
	}
	
	/**
	 * Return the type for a model
	 * 
	 * @return String The correct type
	 */
	public static String convertSingleModel(){
		return COLLECTION_JAVA;
	}
	
	/**
	 * Return the type for an array of models
	 * 
	 * @return String The correct type
	 */
	public static String convertMultiModel(){
		return COLLECTION_JAVA+MULTI_JAVA;
	}

	/**
	 * Generate the type
	 * 
	 * @param parameter The parameter
	 * @return String The correct type
	 */
	public static String generateType(Parameter parameter) {
		Type type = parameter.getType();
		
		if(type instanceof PrimitiveType){ // PrimitiveType
			if(parameter.getUpper() == -1 || parameter.getUpper() > 1) {
				return TypeConversion.convertMultiPrimitive(type.getName());
			}
			return TypeConversion.convertSinglePrimitive(type.getName());
		}
		if(parameter.getUpper() == -1 || parameter.getUpper() > 1) {
			return TypeConversion.convertMultiModel();
		}
		return TypeConversion.convertSingleModel();
	}
}
