/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.test;

import java.io.IOException;

import junit.framework.TestCase;

import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.ETValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;

/**
 *
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 *  
 */
public class ETValidationTest extends TestCase {

	/**
	 * Test method for
	 * 'org.eclipse.mddi.modelbus.toolkit.adapter.validator.ETValidation.validationET(ModelBusPackaging)'
	 */
	public static void testValidationET() {
		String xmlFileName;
		DescriptionModelLoader modelLoader;
		xmlFileName = "Event_emptyName.description";
		try {
			modelLoader = new DescriptionModelLoader(ValidationTest
					.getDescriptionFilesPath()
					+ xmlFileName);
			ETValidation.validationET(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (ETException e) {
			assertEquals(false, false);	
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}
		xmlFileName = "Event_missingName.description";
		try {
			modelLoader = new DescriptionModelLoader(ValidationTest
					.getDescriptionFilesPath()
					+ xmlFileName);
			ETValidation.validationET(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (ETException e) {
			assertEquals(false, false);
		}  catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}	
	}
}
