/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;

/**
 * 
 * Check that ModelingService are correctly formed
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 */
public class MSValidation {

	/**
	 * 
	 * This method validates the part of the description which specifies an
	 * ModelingService.
	 * 
	 * @param mP
	 * @throws MSException
	 */
	public static void validationMS(ModelBusPackaging mP) throws MSException {
		EList mPContents = mP.getContent();
		ModelingServiceInterface msi = null;
		int nextContent = 0;
		boolean msiFound = false;
		while (nextContent < mPContents.size()) {
			Object mPContent = mPContents.get(nextContent);
			if ((mPContent instanceof ModelingServiceInterface) && (!msiFound)) {
				msiFound = true;
				msi = (ModelingServiceInterface) mPContent;
			}
			nextContent++;

			EList servicesList;
			ModelingService service;
			// We recover all the services of the ModelingServiceInterface
			if (msi != null) {
				servicesList = msi.getService();
				for (int i = 0; i < servicesList.size(); i++) {
					service = (ModelingService) servicesList.get(i);
					try {
						Validation.validateName(service.getName(),
								"ModelingService");
					} catch (NameFormatException e) {
						throw new MSException(e.getMessage());
					}
				}
			}
		}
	}
}
