/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.Event;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;

/**
 * 
 * Check that Type are correctly formed
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 */
public class TValidation {

	/**
	 * This method validates the part of the description which specifies Type.
	 * 
	 * @param mp
	 * @throws TException
	 */
	public static void validationT(ModelBusPackaging mp) throws TException {
		EList mpListContents, servicesList;
		ModelingService service;
		EList parametersList;
		EList errorsList;
		EList eventsList;
		EList eventsTypeList;

		mpListContents = mp.getContent();
		ModelingServiceInterface msi = null;
		for (int j = 0; j < mpListContents.size(); j++) {
			Object content = mpListContents.get(j);
			if (content instanceof ModelingServiceInterface) {
				msi = (ModelingServiceInterface) content;

				servicesList = msi.getService();
				eventsList = msi.getPublishedEvent();
				//we have to loop on the ModelingServices
				for (int i = 0; i < servicesList.size(); i++) {
					service = (ModelingService) servicesList.get(i);
					parametersList = service.getParameter();
					errorsList = service.getServiceError();
					checkTypeParameters(parametersList);
					checkTypeErrors(errorsList);
					//we check all the types of the events
					for (int x = 0; x < eventsList.size(); x++) {
						Event event = (Event) eventsList.get(x);
						eventsTypeList = event.getEventInfo();
						//we check all the types (EList of type)
						//of each event
						checkEventsType(eventsTypeList);
					}
				}
			}
		}
	}

	/**
	 * this method checks the types of Event
	 * 
	 * @param eventsTypeList 
	 * @throws TException
	 */
	private static void checkEventsType(EList eventsTypeList) throws TException {
		Type type;
		for (int i = 0; i < eventsTypeList.size(); i++) {
			type = (Type) eventsTypeList.get(i);
			checkTypes(type);
		}
	}

	/**
	 * this method checks the types of Error
	 *
	 * @param errorsList 
	 * @throws TException
	 */
	private static void checkTypeErrors(EList errorsList) throws TException {
		Error erreur;
		Type typeError;

		for (int i = 0; i < errorsList.size(); i++) {
			erreur = (Error) errorsList.get(i);
			typeError = erreur.getType();
			checkTypes(typeError);
			
		}

	}

	/**
	 * this method checks the types of Parameter
	 * 
	 * @param parametersList 
	 * @throws TException
	 */
	private static void checkTypeParameters(EList parametersList)
			throws TException {
		Parameter parameter;
		Type typeParameter;

		for (int i = 0; i < parametersList.size(); i++) {
			parameter = (Parameter) parametersList.get(i);
			typeParameter = parameter.getType();
			checkTypes(typeParameter);
		}
	}

	/**
	 * this method checks the types and if : 
	 * - the user give a name to the types 
	 * - the user give a type PrimitiveType or ModelType and nothing else
	 * 
	 * @param type 
	 * @throws TException
	 */
	private static void checkTypes(Type type) throws TException {
		//we check every problem cases
		//don't have a name for the type
		if(type == null){
		throw new TException("A Type " 
				+ "is not referenced ");
	    }
		try {
			Validation.validateName(type.getName(), "Type");
		} catch (NameFormatException e) {
			throw new TException(e.getMessage());
		}
		if (!(type instanceof PrimitiveType)) {
			if (type instanceof ModelType) {
				//and it has no name
				try {
					Validation.validateName(((ModelType) type).getName(),
							"ModelType");
				} catch (NameFormatException e) {
					throw new TException(e.getMessage());
				}
			}
			//it's not a PrimtiveType and not a ModelType
			//we raise an exception
			else {
				throw new TException("Type " + type.getName()
						+ "must be a ModelType or a PrimitiveType ");
			}
		}
	}
}
