/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit;

import java.util.Hashtable;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.Generator;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;

public class ToolKit {
    protected static final String HELP_OPTION = "-help";
    protected static final String OUTPUT_DIRECTORY_OPTION = "-directory";
    protected static final String OUTPUT_PACKAGE_OPTION = "-package";

    public static void main(String[] args) {
        try {
            Hashtable<String, String> arguments = new Hashtable<String, String>();
            int i = 1;
            while (i < args.length) {
                if (args[i].compareTo(OUTPUT_DIRECTORY_OPTION) == 0 || args[i].compareTo(OUTPUT_PACKAGE_OPTION) == 0) {
                    arguments.put(args[i], args[i + 1]);
                    ++i;
                } else {
                    throw new Exception();
                }
                ++i;
            }
            String fileName = args[0];
            String outputDirectory = (String)arguments.get(OUTPUT_DIRECTORY_OPTION);
            String outputPackage = (String)arguments.get(OUTPUT_PACKAGE_OPTION);
            if (outputDirectory == null) {
                outputDirectory = ".";
            }
            if (outputPackage == null) {
                outputPackage = "";
            }
            try {
                DescriptionModelLoader modelLoader = new DescriptionModelLoader(fileName);
                Validation.globalValidation(modelLoader.getModelBusPackaging());
                Generator.generateAdapter(modelLoader, outputDirectory, outputPackage);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
        }
        catch (Exception e) {
            ToolKit.printHelp();
        }
    }

    protected static void printHelp() {
        System.out.println("Usage: java -jar ToolKit.jar tool_description_file [-options]\n\nwhere options include:\n\t-directory\tto specify the output directory for the generated files\n\t-package\tto specify the package for the generated files\n\t-help\tto print this message\n\nFor further help please see the user manual\n");
    }
}

