/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;

public class EValidation {
    public static final int MIN_INSTANCES_INFERIOR = 0;
    public static final int MAX_INSTANCES_INFERIOR = -1;

    public static void validationE(ModelBusPackaging mp) throws EException {
        EList mpListContents = mp.getContent();
        ModelingServiceInterface msi = null;
        int j = 0;
        while (j < mpListContents.size()) {
            Object content = mpListContents.get(j);
            if (content instanceof ModelingServiceInterface) {
                msi = (ModelingServiceInterface)content;
                EList servicesList = msi.getService();
                int i = 0;
                while (i < servicesList.size()) {
                    ModelingService service = (ModelingService)servicesList.get(i);
                    EList errorsList = service.getServiceError();
                    EValidation.checkErrorsList(errorsList, mpListContents);
                    ++i;
                }
            }
            ++j;
        }
    }

    private static void checkErrorsList(EList errorsList, EList mpListContents) throws EException {
        int i = 0;
        while (i < errorsList.size()) {
            Error error = (Error)errorsList.get(i);
            try {
                Validation.validateName(error.getName(), "Error");
                Validation.validateName(error.getType().getName(), "Error Type");
            }
            catch (NameFormatException e) {
                throw new EException(e.getMessage());
            }
            if (error.getUpper() == 0 && error.getLower() == 0) {
                throw new EException("Error " + error.getName() + " has its lower and upper attributes equal to 0, it must be different");
            }
            if (error.getUpper() < error.getLower() && error.getUpper() > 0) {
                throw new EException("Error " + error.getName() + " has its lower attribute superior as its upper attribute,the lower attribute must be inferior or equal to the upper attribute");
            }
            if (error.getUpper() < -1) {
                throw new EException("Error " + error.getName() + " has its upper attribute inferior than " + -1 + " the upper attribute must be superior or equal than " + -1);
            }
            if (error.getLower() < 0) {
                throw new EException("Error " + error.getName() + " has its lower attribute inferior than " + 0 + " the upper attribute must be superior or equal than " + 0);
            }
            ++i;
        }
    }
}

