/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;

public class MSIValidation {
    public static void validateMSI(ModelBusPackaging mP) throws MSIException {
        EList mPContents = mP.getContent();
        ArrayList<String> msiNameList = new ArrayList<String>();
        int nextContent = 0;
        while (nextContent < mPContents.size()) {
            Object mPContent = mPContents.get(nextContent);
            if (mPContent instanceof ModelingServiceInterface) {
                ModelingServiceInterface msi = (ModelingServiceInterface)mPContent;
                try {
                    Validation.validateName(msi.getName(), "ModelingServiceInterface");
                }
                catch (NameFormatException e) {
                    throw new MSIException(e.getMessage());
                }
                if (!msiNameList.contains(msi.getName())) {
                    if (msi.getPublishedEvent().isEmpty() && msi.getService().isEmpty()) {
                        throw new MSIException("ModelingServiceInterface " + msi.getName() + " is empty, it must have at least one ModelingService or EventType");
                    }
                    msiNameList.add(msi.getName());
                } else {
                    throw new MSIException("At least two ModelingServiceInterface have the same name : " + msi.getName() + ", it must have different names");
                }
            }
            ++nextContent;
        }
    }
}

