/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;

public class MetaSValidation {
    public static final int MIN_INSTANCES_INFERIOR = 0;
    public static final int MAX_INSTANCES_INFERIOR = -1;

    public static void validateMetaS(ModelBusPackaging mP) throws MetaSException {
        ModelType mT;
        EList mPcontents = mP.getContent();
        ArrayList<ModelType> modelTypeList = new ArrayList<ModelType>();
        int nextContent = 0;
        while (nextContent < mPcontents.size()) {
            Object mPcontent = mPcontents.get(nextContent);
            if (mPcontent instanceof ModelType) {
                mT = (ModelType)mPcontent;
                modelTypeList.add(mT);
            }
            ++nextContent;
        }
        int i = 0;
        while (i < modelTypeList.size()) {
            mT = (ModelType)modelTypeList.get(i);
            if (!mT.getContent().isEmpty()) {
                EList mTcontents = mT.getContent();
                int j = 0;
                while (j < mTcontents.size()) {
                    Object mTcontent = mTcontents.get(j);
                    if (mTcontent instanceof MetaclassSpecification) {
                        MetaclassSpecification metaS = (MetaclassSpecification)mTcontent;
                        try {
                            Validation.validateName(metaS.getName(), "MetaclassSpecification");
                        }
                        catch (NameFormatException e) {
                            throw new MetaSException(e.getMessage());
                        }
                        if (metaS.getUpper() == 0 && metaS.getLower() == 0) {
                            throw new MetaSException("MetaclassSpecification " + metaS.getName() + " has its lower and upper attributes equal to 0, it must be different");
                        }
                        if (metaS.getUpper() < metaS.getLower() && metaS.getUpper() > 0) {
                            throw new MetaSException("MetaclassSpecification " + metaS.getName() + " has its lower attribute superior as its upper attribute,the lower attribute must be inferior or equal to the upper attribute");
                        }
                        if (metaS.getUpper() < -1) {
                            throw new MetaSException("MetaclassSpecification " + metaS.getName() + " has its upper attribute inferior than " + -1 + " the upper attribute must be superior or equal than " + -1);
                        }
                        if (metaS.getLower() < 0) {
                            throw new MetaSException("MetaclassSpecification " + metaS.getName() + " has its lower attribute inferior than " + 0 + " the upper attribute must be superior or equal than " + 0);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

