/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.DirectionKind;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TypeFormatException;

public class PValidation {
    public static final int DEFAULT_LOWER = 0;
    public static final int DEFAULT_UPPER = 1;

    public static void validationParameter(ModelBusPackaging mP) throws PException {
        EList mPContents = mP.getContent();
        int nextContent = 0;
        while (nextContent < mPContents.size()) {
            Object mPContent = mPContents.get(nextContent);
            ++nextContent;
            if (!(mPContent instanceof ModelingServiceInterface)) continue;
            ModelingServiceInterface msi = (ModelingServiceInterface)mPContent;
            EList servicesList = msi.getService();
            int i = 0;
            while (i < servicesList.size()) {
                ModelingService service = (ModelingService)servicesList.get(i);
                EList parametersList = service.getParameter();
                Vector<Parameter> paramList = new Vector<Parameter>();
                int j = 0;
                while (j < parametersList.size()) {
                    Parameter parameter = (Parameter)parametersList.get(j);
                    try {
                        Validation.validateName(parameter.getName(), "Parameter");
                    }
                    catch (NameFormatException e) {
                        throw new PException(e.getMessage());
                    }
                    try {
                        Validation.validateType(parameter.getType(), "Parameter");
                    }
                    catch (TypeFormatException e) {
                        throw new PException(e.getMessage());
                    }
                    if (parameter.getDirection() == null) {
                        parameter.setDirection(DirectionKind.IN_LITERAL);
                    }
                    if (parameter.getLower() == 0 && parameter.getUpper() == 0) {
                        throw new PException("Parameter " + parameter.getName() + " has its lower and upper attributes equal to 0");
                    }
                    if (parameter.getUpper() < parameter.getLower() && parameter.getUpper() > 0) {
                        throw new PException("Parameter " + parameter.getName() + " has its lower attribute superior as its upper attribute");
                    }
                    if (parameter.getDirection().getValue() != 0 && parameter.getDirection().getValue() != 1 && parameter.getDirection().getValue() != 2) {
                        throw new PException("Direction value " + parameter.getDirection() + " must be : \"in\" or \"out\"or \"inout\" ");
                    }
                    int k = 0;
                    while (k < paramList.size()) {
                        if (((Parameter)paramList.get(k)).getName().equals(parameter.getName())) {
                            if (!((Parameter)paramList.get(k)).getType().equals(parameter.getType())) {
                                paramList.add(parameter);
                            } else {
                                throw new PException("This parameter is already exist");
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

