/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.AbstractGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.InputHolder;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.OutputHolder;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.ProviderInterfaceGenerator;

public class SkeletonGenerator
extends AbstractGenerator {
    protected static final String EXECUTE_METHOD_PREFIX = "execute_";
    private String interfaceName;

    public SkeletonGenerator(Tool t, OutputStream os) {
        super(t, os);
        this.interfaceName = new ProviderInterfaceGenerator(this.toolDescription, this.fileOs).getFileName();
        this.FILE_POSTFIX = "Skeleton";
    }

    public SkeletonGenerator(Tool tool, String outputDirectory) {
        super(tool, outputDirectory);
        this.interfaceName = new ProviderInterfaceGenerator(this.toolDescription, this.fileOs).getFileName();
        this.FILE_POSTFIX = "Skeleton";
        this.fileOs = this.getFileOs();
    }

    protected void generateImport() throws IOException {
        this.fileOs.write("import java.util.Collection;\n".getBytes());
        this.fileOs.write("import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;\n".getBytes());
        this.fileOs.write("import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;\n".getBytes());
        this.fileOs.write("import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;\n".getBytes());
        this.fileOs.write("\n".getBytes());
    }

    public void generateClassName() throws IOException {
        this.fileOs.write(("public class " + this.getFileName() + " implements GenericProvider {\n").getBytes());
    }

    public void generateConstructor() throws IOException {
        String constructor = "";
        constructor = String.valueOf(constructor) + "\tprivate ";
        constructor = String.valueOf(constructor) + this.interfaceName;
        constructor = String.valueOf(constructor) + " concreteTool;\n\n";
        constructor = String.valueOf(constructor) + "\tpublic ";
        constructor = String.valueOf(constructor) + this.getFileName();
        constructor = String.valueOf(constructor) + "(";
        constructor = String.valueOf(constructor) + this.interfaceName;
        constructor = String.valueOf(constructor) + " concreteTool";
        constructor = String.valueOf(constructor) + ") {\n";
        constructor = String.valueOf(constructor) + "\t\tthis.concreteTool = concreteTool;\n";
        constructor = String.valueOf(constructor) + "\t}\n";
        this.fileOs.write(constructor.getBytes());
    }

    protected void generateAdditionalMethods(ModelingServiceInterface msi) throws IOException {
        String code = "";
        code = String.valueOf(code) + "\tpublic Object[] execute(String serviceName, Object[] parameterValues) throws SessionNeeded, ModelingServiceError {\n";
        code = String.valueOf(code) + "\t\t";
        EList services = msi.eContents();
        int i = 0;
        while (i < services.size()) {
            ModelingService ms = (ModelingService)services.get(i);
            code = String.valueOf(code) + this.generateIf(ms);
            ++i;
        }
        code = String.valueOf(code) + "{\n";
        code = String.valueOf(code) + "\t\t\tthrow new ModelingServiceError (\"No such service: \"+serviceName, null);\n";
        code = String.valueOf(code) + "\t\t}\n";
        code = String.valueOf(code) + "\t}\n\n";
        this.fileOs.write(code.getBytes());
    }

    String generateIf(ModelingService ms) {
        InputHolder[] inputs = this.createInputHolders(ms);
        OutputHolder[] outputs = this.createOutputHolders(ms);
        String outputType = this.generateOutputParameters(outputs);
        String code = "";
        code = String.valueOf(code) + "if (serviceName.equals(\"";
        code = String.valueOf(code) + ms.getName();
        code = String.valueOf(code) + "\")){\n";
        code = String.valueOf(code) + "\t\t\t";
        if (outputType.equals("void")) {
            code = String.valueOf(code) + "concreteTool.execute_";
        } else {
            code = String.valueOf(code) + outputType;
            code = String.valueOf(code) + " result=concreteTool.execute_";
        }
        code = String.valueOf(code) + ms.getName();
        code = String.valueOf(code) + "(";
        code = String.valueOf(code) + this.generateExecuteParameters(inputs);
        code = String.valueOf(code) + ");\n";
        code = outputType.equals("void") ? String.valueOf(code) + "\t\t\tObject[] returnValues = new Object[0];\n" : String.valueOf(code) + "\t\t\tObject[] returnValues = new Object[" + outputs.length + "];\n";
        if (!outputType.equals("void")) {
            if (outputs.length == 1) {
                code = String.valueOf(code) + "\t\t\treturnValues[0]=result;\n";
            } else {
                int i = 0;
                while (i < outputs.length) {
                    code = String.valueOf(code) + "\t\t\treturnValues[" + i + "]=result." + outputs[i].getName() + ";\n";
                    ++i;
                }
            }
        }
        code = String.valueOf(code) + "\t\t\treturn returnValues;\n";
        code = String.valueOf(code) + "\t\t}else ";
        return code;
    }

    String generateExecuteParameters(InputHolder[] inputs) {
        String code = "";
        int i = 0;
        while (i < inputs.length) {
            code = String.valueOf(code) + "(";
            code = String.valueOf(code) + inputs[i].getType();
            code = String.valueOf(code) + ") parameterValues[" + i + "]";
            if (i != inputs.length - 1) {
                code = String.valueOf(code) + ",";
            }
            ++i;
        }
        return code;
    }

    public static void main(String[] params) {
        try {
            DescriptionModelLoader loader = new DescriptionModelLoader("OCLTool.description");
            SkeletonGenerator gen = new SkeletonGenerator(loader.getTool(), System.out);
            gen.generateContent("some.pack", loader.getModelingServiceInterfaces()[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

